// vim: zdefiniuj parametr set undofile:
// Program: 06-fibonacci

#include <iostream>
#include <vector>

// Usu komentarz z jednego z dwch wierszy poniej
// #define ORDINARY_FIB
// #define CACHED_FIB
#define OPTIMIZED_CACHED_FIB


#ifdef ORDINARY_FIB
// Zwyka rekurencyjna implementacja funkcji Fibbonaciego.
// Jest ona wyjtkowo niewydajna - jej zoono obliczeniowa wynosi O(2^n).
unsigned int fib(unsigned int n)
{
    return n == 0 ? 0 :
           n == 1 ? 1 :
                    fib(n - 1) + fib(n -2);
}
#endif


#ifdef CACHED_FIB
std::vector<unsigned int> cache{0, 1};

// Implementacja funkcji Fibbonaciego, ktra buforuje wszystkie
// poprzenio wyliczone wyniki
unsigned int fib(unsigned int n)
{
    if (cache.size() > n) {
        std::cerr << "using cache " << n << std::endl;
        return cache[n];

    } else {
        const auto result = fib(n - 1) + fib(n - 2);
        cache.push_back(result);
        return result;
    }
}
#endif


#ifdef OPTIMIZED_CACHED_FIB

// Aby wyznaczy cig Fibbonaciego, musimy buforowa
// dwa ostatnie wyniki
class fib_cache {
public:
    fib_cache()
        : m_previous{0}
        , m_last{1}
        , m_size{2}
    {
    }

    size_t size() const
    {
        return m_size;
    }

    unsigned int operator[](unsigned int n) const
    {
        return n == m_size - 1 ? m_last :
               n == m_size - 2 ? m_previous :
               throw std::out_of_range("Warto nie znajduje si ju w buforze");
    }

    void push_back(unsigned int value)
    {
        m_size++;
        m_previous = m_last;
        m_last = value;
    }

private:
    unsigned int m_previous;
    unsigned int m_last;
    size_t m_size;

} cache;

unsigned int fib(unsigned int n)
{
    if (cache.size() > n) {
        return cache[n];

    } else {
        const auto result = fib(n - 1) + fib(n - 2);
        cache.push_back(result);
        return result;
    }
}
#endif


int main(int argc, char* argv[])
{
    setlocale(LC_ALL, "polish");

    for (int i = 0; i < 10; ++i) {
        std::cout << fib(i) << std::endl;
    }

    return 0;
}
