
#include <string>
#include <iostream>
#include <vector>
#include <algorithm>

#include "../../common/person.h"

std::string name(const person_t &person)
{
    return person.name();
}

bool is_female(const person_t &person)
{
    return person.gender() == person_t::female;
}

bool is_not_female(const person_t &person)
{
    return !is_female(person);
}

int main(int argc, char *argv[])
{
    std::vector<person_t> people {
        { "Dawid"  , person_t::male   },
        { "Janina" , person_t::female },
        { "Martaa" , person_t::female },
        { "Piotr"  , person_t::male   },
        { "Renata" , person_t::female },
        { "Tomasz" , person_t::male   }
    };

    // Filtrowanie za pomoc idiomu erase-remove (punkt 2.2.5)
    people.erase(
        std::remove_if(people.begin(), people.end(),
                       is_not_female),
        people.end());

    for (const person_t& person: people) {
        std::cout << person.name() << '\n';
    }

    return 0;
}
