
#include <iostream>
#include <string>
#include <vector>
#include <unordered_map>
#include <fstream>
#include <algorithm>
#include <iterator>

/**
 * Ta funkcja otwiera plik okrelony przez argument filename
 * i zlicza w nim liczb wierszy
 */
int count_lines(const std::string &filename)
{
    std::ifstream in(filename);

    // Tworzymy iterator dla strumienia wejciowego i przekazujemy go
	// do algorytmu count w celu wyznaczenia liczby znakw nowego wiersza
    return std::count(
        std::istream_iterator<char>(in >> std::noskipws),
        std::istream_iterator<char>(),
        '\n');
}

/**
 * Majc podan list plikw, funkcja ta zwraca list
 * zawierajc liczby wierszy w kadym z nich
 */
std::vector<int>
count_lines_in_files(const std::vector<std::string> &files)
{
	// Poniewa znamy rozmiar wynikowego wektora, moemy wstpnie
	// przydzieli pami dla wymaganej liczby elementw
    std::vector<int> results(files.size());

	// Zamiast uywa prostej ptli for, jak w przykadzie count-lines-stdcount,
	// wykorzystujemy tu algorytm std::transform, aby zamieni
	// list nazw plikw na list z liczbami wierszy
    std::transform(files.cbegin(), files.cend(),
                   results.begin(),
                   count_lines);

    return results;
}

int main(int argc, char *argv[])
{
    auto results = count_lines_in_files({"main.cpp", "Makefile"});

    for (const auto &result: results) {
        std::cout << result << " wiersz(e/y)\n";
    }

    return 0;
}

