#include <iostream>
#include <algorithm>
#include <numeric>

#include <vector>
#include <string>
#include <type_traits>

#include "type_utils.h"

// Funkcja, ktra sumuje wszystkie elementy nalece do kolekcji iterowalnej
template < typename C
         , typename R = contained_type<C>
         >
R sum_iterable(const C &collection)
{
    std::cout << "Oto funkcja sum_iterable\n";
    return std::accumulate(
            begin(collection),
            end(collection),
            R());
}


// Funkcja sumujca wszystkie elementy kolekcji,
// ktra zawiera definicj zagniedonego typu value_type
template < typename C
         , typename R = typename C::value_type
         >
R sum_collection(const C &collection)
{
    std::cout << "Oto funkcja sum_collection\n";
    return std::accumulate(
            begin(collection),
            end(collection),
            R());
}



// Funkcja sumujca wszystkie elementy kolekcji.
// Funkcja ta najpierw prbuje uywa typu C::value_type,
// a nastpnie contained_type<C>
template <typename C>
auto sum(const C &collection)
{
    if constexpr (has_value_type<C>()) {
        return sum_collection(collection);
    } else if constexpr (is_iterable<C>()) {
        return sum_iterable(collection);
    } else {
        static_assert(false_<C>(), "Suma moe zosta wyznaczona jedynie w przypadku kolekcji.");
    }
}


// Metafunkcja, ktra sprawdza, czy dwa typy s identyczne
template <typename T1, typename T2>
struct is_same: std::false_type {};

template <typename T>
struct is_same<T, T>: std::true_type {};


int main(int argc, char *argv[])
{ 
    setlocale(LC_ALL, "polish");
	
	// Usu poniszy komentarz, by kompilator
	// wywietli dokadny wynik metafunkcji contained_type
    // error<contained_type<std::vector<std::string>>>();

	// Potwierdzenie, e std::vector<std::string> zawiera
	// wartoci typu std::string
    static_assert(
        is_same<
            contained_type<std::vector<std::string>>,
            std::string
        >(), "Oczekiwano, e contained_type zwrci std::string.");

	// Wywoanie funkcji sumowania z wektorem liczb cakowitych.
	// W wyniku otrzymamy liczb cakowit.
    std::vector<int> xs { 1, 2, 3, 4 };
    std::cout << sum_iterable(xs) << std::endl;
    std::cout << sum_collection(xs) << std::endl;
    std::cout << sum(xs) << std::endl;

	// Usu poniszy komentarz, aby wczy static_assert dla funkcji sum
    // sum(1);

    return 0;
}
