/* losowy_odczyt.c - Listing 12.7 */

#include <stdio.h>
#include <stdlib.h> /* Dla rand() i srand(). */
#include <time.h> /* Dla time() uywanej w srand(). */

/* Ustaw ciek i nazw pliku. */
#define PLIK "C:\\testy\\liczby.dat"

/* Liczba elementw do zapisania. */
#define ELEM 50

int main (void) {
	
  /* Potrzebujemy wskanika typu FILE. */
  FILE *fp;
	
  /* Potrzebujemy dwe zmienne typu int. */
  int przesuniecie, liczba;

  /* Prba otwarcia pliku binarnego do odczytu. */
  fp = fopen(PLIK, "rb");
	
  if (fp != NULL) { /* Plik zosta otwarty. */
		
    /* Znajd losowe przesunicie. */
    srand((unsigned)time(NULL));
    przesuniecie = rand() % ELEM;
    przesuniecie *= sizeof(int);
		
    /* Odczytaj warto znajdujc si w losowym przesuniciu. */
    fseek (fp, przesuniecie, SEEK_SET);
    fread (&liczba, sizeof(liczba), 1, fp);
		
    /* Wywietl liczb. */
    printf("Liczba umieszczona w wylosowanym miejscu: %d.\n", liczba);

  } else {
    printf ("Nie udao si otworzy pliku.\n");
    return 1; /* Wyjcie z funkcji i aplikacji. */
  }
	
  /* Zamknicie pliku. */
  if (fclose(fp) != 0) {
    printf ("Nie udao si zamkn pliku.\n");
  }

  getchar(); /* Pauza. */
  return 0;
}
