/* kopiowanie.c - Listing 11.5 */

#include <stdio.h>
#include <string.h> /* Dla strncpy(). */

void wyczysc_wejscie (void); /* Prototyp funkcji. */

#define ILE_TEKSTOW 10
#define DL_TEKSTU 10

int main (void) {
	
  /* Zadeklaruj wielowymiarow tablic znakw. */
  char wyrazy[ILE_TEKSTOW][DL_TEKSTU];
	
  char wejscie[DL_TEKSTU]; /* Dane od uytkownika. */
	
  int i; /* Zmienna ptli. */
  int ile = 0; /* Zlicza wpisane wyrazy. */
	
  /* Odczytaj maksymalnie ILE_TEKSTOW wyrazw. */
  for (i = 0; i < ILE_TEKSTOW; ++i) {
		
    /* Popro o wpisanie wyrazu i pobierz go z wejcia. */
    printf("Wpisz wyraz (lub 0, by wyj): ");
    scanf("%9s", wejscie);
    wyczysc_wejscie();
		
    /* Sprawd, czy wpisano 0. */
    if (wejscie[0] == '0') break;
		
    /* Skopiuj wejcie do tablicy. */
    strncpy(wyrazy[i], wejscie, (DL_TEKSTU - 1));
		
    /* Zwiksz licznik wyrazw. */
    ++ile;
		
  } /* Koniec ptli. */
	
  printf("Wpisanio %d wyrazw.\n", ile);
	
  getchar();
  return 0;
	
}

/* Funkcja czyci wejcie ze zbdnych znakw. */
void wyczysc_wejscie (void) {
	
  char smieci; // W celu pozbycia si nadmiarowych znakw.
	
  // Przejd przez wejcie i ignoruj nowe znaki.
  do {
    smieci = getchar();
  } while (smieci != '\n' );

} /* Koniec funkcji wyczysc_wejscie(). */
