// Rational.cpp - Listing 12.3.

// Andi Signer i Larry Ullman.

// Plik implementacji klasy
// Rational. Klasa suy do
// reprezentowania liczb
// wymiernych (uamkw).

// Potrzebujemy pliku nagwkowego klasy.
#include "Rational.h"

// Potrzebujemy pliku iostream,
// bo odwoujemy si do ostream.
#include <iostream>

// Deklaracja przestrzeni nazw.
namespace myMath {

// Definicja konstruktora.
Rational::Rational(int num, int denom) {
    numerator = num;
    denominator = denom;
    normalize();
}

// Przecienia operatorw.
Rational Rational::operator+(Rational rhs) {

    // a   c   a*d   c*b   a*d + c*b
    // - + - = --- + --- = ---------
    // b   d   b*d   b*d      b*d

    int a = numerator;
    int b = denominator;
    int c = rhs.numerator;
    int d = rhs.denominator;
    
    int e = a*d + c*b;
    int f = b*d;
    
    return Rational(e, f);
}

Rational Rational::operator-(Rational rhs) {

    // a   c   a   -c
    // - - - = - + ---
    // b   d   b    d

    rhs.numerator = -rhs.numerator;

    return operator+(rhs); 
}

Rational Rational::operator*(Rational rhs) {

    // a   c   a*c
    // - * - = ---
    // b   d   b*d

    int a = numerator;
    int b = denominator;
    int c = rhs.numerator;
    int d = rhs.denominator;
    
    int e = a*c;
    int f = b*d;
    
    return Rational(e, f);
}

Rational Rational::operator/(Rational rhs) {

    // a   c   a   d
    // - / - = - * -
    // b   d   b   c

    int t = rhs.numerator;
    rhs.numerator = rhs.denominator;
    rhs.denominator = t;

    return operator*(rhs); 
}

// Definicje metod.
void Rational::normalize() {

    // Sprawd znaki.
    if (denominator < 0) {
        numerator = -numerator;
        denominator = -denominator;
    }

    // Oblicz najwikszy wsplny dzielnik a/b
    // algorytmem Euklidesa
    int a = abs(numerator);
    int b = abs(denominator);
    while (b > 0) {
        int t = a % b;
        a = b;
        b = t;
    }
    
    numerator /= a;
    denominator /= a;
}

// Definicja operatora operator<<()
std::ostream& operator<<(std::ostream& os, Rational f) {

    // Wypisz do pobranego strumienia
    // licznik i mianownik uamka
    os << f.numerator << "/" << f.denominator;
    
    // Zwr obiekt strumienia, aby umoliwi zapisy kaskadowe
    return os;

}

} // Koniec przestrzeni nazw.
