// copyctor.cpp - Listing 11.5.

#include <iostream>

#include <string>

// Zadeklaruj klas MyClass.
class MyClass {
public:

    // "Zwyczajny" konstruktor oczekuje przekazania
    // wskanika liczby cakowitej.
    MyClass(int *p);
    
    //To jest konstruktor kopiujcy.
    MyClass(const MyClass &rhs);
    
    // Klasa posiada pami przydzielan dynamiczne,
    // wic potrzebujemy destruktora, ktry j zwolni.
    ~MyClass();
    
    // Deklaracja operatora przypisania.
    MyClass &operator=(const MyClass &rhs);

private:
    // Skadowa przechowujca wskanik na int.
    int *ptr;
};

// Implementacja konstruktora.
MyClass::MyClass(int *p) {
    std::cout << "Wywoanie zwykego konstruktora obiektu "
    << this << ".\n";
    // To zwyczajny konstruktor, wic po
    // prostu zapisujemy przekazany wskanik.
    ptr = p;
    std::cout << "Koniec zwykego konstruktora obiektu "
    << this << ".\n";
}

// Implementacja konstruktora kopiujcego.
MyClass::MyClass(const MyClass &rhs) {
    std::cout << "Wywoanie konstruktora kopiujcego obiektu "
    << this << ".\n";
    std::cout << "rhs to obiekt " << &rhs << "\n";

    // To konstruktor kopiujcy. Aby utworzy kopi rhs,
    // trzeba przypisa rhs do *this.
    *this = rhs;
    
    std::cout << "Koniec konstruktora kopiujcego obiektu "
    << this << ".\n";
}

// Implementacja destruktora.
MyClass::~MyClass() {
    std::cout << "Wywoanie destruktora obiektu "
    << this << ".\n";
    
    // Poprostu zwolnij ptr.
    delete ptr;
    
    std::cout << "Koniec destruktora obiektu "
    << this << ".\n";
}

// Implementacja operatora przypisania.
MyClass &MyClass::operator=(const MyClass &rhs) {
    std::cout << "Wywoanie operatora przypisania obiektu "
    <<this << ".\n";
    std::cout << "rhs to obiekt " << &rhs << "\n";
    
    // Sprawd, czy uytkownik napisa co w rodzaju:
    // "obj1 = obj1". Jeli tak, nic nie rb.
    if (this != &rhs) {

        // Zwolnij pami wskazywan przez this->ptr.
        std::cout << "zwolnienie this->ptr\n";
        delete ptr;
        
        // Utwrz kopi rhs.ptr
        std::cout << "przydzia nowej wartoci int i przypisanie *rhs.ptr\n";
        ptr = new int;
        *ptr = *rhs.ptr;
        
    } else {
        std::cout << "this i rhs to ten sam obiekt, nic nie trzeba robi!\n";
    }

    std::cout << "Koniec operatora przypisania obiektu "
    << this << ".\n";

    // Zwr referencj obiektu.
    return *this;
}        


int main() {

    // Wypisz wizualny separator .
    std::cout << "----------------------------------------------------\n";
    { // Utwrz blok kodu dla testu zasigu.

        // Utwrz dwa obiekty, obj1 i obj2.
        // Przypisz obj1 do obj2.
        MyClass obj1(new int(1));
        MyClass obj2(new int(2));
        obj2 = obj1;
        
    }
    
    std::cout << "----------------------------------------------------\n";
    
    {
        // Utwrz obiekt obj3.
        MyClass obj3(new int(1));
        
        // Utwrz obiekt obj4.
        // Zainicjalizuj go wartoci obj3.
        MyClass obj4 = obj3;
        
    }

    std::cout << "----------------------------------------------------\n";
    
    {

        // Utwrz obiekt obj5.
        // Sprbuj przypisa go do samego siebie.
        MyClass obj5(new int(1));
        obj5 = obj5;
        
    }

    std::cout << "----------------------------------------------------\n";
    
    std::cout << "Nacinij Enter albo Return, aby kontynuowa.\n";
    std::cin.get();
    return 0;
}
