// company2.cpp - Listing 11.4

#include <iostream>

#include <string>

// Zadeklaruj klas Company (firma).
class Company {
public:
    Company(std::string name);
    virtual void printInfo();

protected:
    std::string name;
};

// Zadeklaruj klas Publisher (wydawnictwo).
// Publisher dziedziczy po Company.
class Publisher : public Company {
public:
    Publisher(std::string name, int booksPublished);
    virtual void printInfo();

private:
    int booksPublished;
};

// Implementacje metod.
Company::Company(std::string name) {
    this->name = name;
}

void Company::printInfo() {
    std::cout << "To jest firma o nazwie '" << name << "'.\n";
}

Publisher::Publisher(std::string name, int booksPublished) : Company(name) {
    this->booksPublished = booksPublished;
}

void Publisher::printInfo() {
    std::cout << "To jest wydawnictwo o nazwie '" << name << "'; wydao " << booksPublished << " ksiek.\n";
}

// Prototyp funkcji-wytwrni;
// funkcja zwraca wskanik na Company
Company *createCompany(std::string name, int bookPublished = -1);

int main() {
    
    // Utwrz obiekt firmy w pamici,
    // wywoujc funkcj createCompany().
    Company *company = createCompany("IBM");
    
    // Wypisz informacje o firmie.
    company->printInfo();
    
    // Zwolnij obiekt firmy.
    delete company;
    company = NULL;
    
    // Utwrz obiekt wydawcy.
    company = createCompany("Powielacz", 99999);
    
    // Wypisz informacje o firmie.
    company->printInfo();
    
    // Usu obiekt firmy.
    delete company;
    company = NULL;
    
    std::cout << "Nacinij Enter albo Return, aby kontynuowa.\n";
    std::cin.get();
    return 0;
}

// Definicja funkcji-wytwrni.
Company *createCompany(std::string name, int booksPublished /* = -1 */) {

    // Na podstawie wartoci booksPublished
    // wybierz typ obiektu: COmpany albo Publisher.
    if (booksPublished < 0) {
        return new Company(name);
    } else {
        return new Publisher(name, booksPublished);
    }

}
        
