// student2.cpp - Listing 9.8

#include <iostream>

#include <string>

// Deklaracja klasy Person
class Person {
public:
    Person(std::string theName);
                
    void introduce();

protected:
    std::string name;
};


// Poinformuj kompilator, e wszystkie przysze
// podklasy klasy Teacher maj zawiera jedn
// kopi atrybutw klasy Person.
// Osiga si to przez dziedziczenie wirtualne.
class Teacher : virtual public Person {
public:
    Teacher(std::string theName, std::string theClass);

    void teach();
    void introduce();

protected:
    std::string clazz;
};

// Poinformuj kompilator, e wszystkie przysze
// podklasy klasy Teacher maj zawiera jedn
// kopi atrybutw klasy Person.
// Osiga si to przez dziedziczenie wirtualne.
class Student : virtual public Person {
public:
    Student(std::string theName, std::string theClass);

    void attendClass();
    void introduce();

protected:
    std::string clazz;
};

// Deklaracja klasy TeachingStudent.
// Klasa dziedziczy po klasach Student i Teacher.                              
class TeachingStudent : public Student, public Teacher {
public:
    TeachingStudent(std::string theName,
        std::string classTeaching,
        std::string classAttending);

    void introduce();
};


// Definicje metod.
Person::Person(std::string theName) {
    name = theName;
}

void Person::introduce() {
    std::cout << "Witam, nazywam si " << name << "\n";
}

Teacher::Teacher(std::string theName, std::string theClass)
: Person(theName) {
    clazz = theClass;
}

void Teacher::teach() {
    std::cout << name << " wykada ";
    std::cout << "'" << clazz << "'.\n";
}

void Teacher::introduce() {
    std::cout << "Witam, nazywam si " << name << " i bd wykada '" << clazz << "'.\n";
}

Student::Student(std::string theName, std::string theClass)
: Person(theName) {
    clazz = theClass;
}

void Student::attendClass() {
    std::cout << name << " studiuje ";
    std::cout << "'" << clazz << "'.\n";
}

void Student::introduce() {
    std::cout << "Dzie dobry, nazywam si " << name << " i studiuj '" << clazz << "'.\n";
}
    
// Konstruktor klasy TeachingStudent musi wywoa
// konstruktory wszystkich klas bazowych!
TeachingStudent::TeachingStudent(
    std::string theName,
    std::string classTeaching,
    std::string classAttending)
: Teacher(theName, classTeaching), Student(theName, classAttending), Person(theName)
{
}
                       
void TeachingStudent::introduce() {
    // Obiekt TeachingStudent wci dziedziczy dwie kopie
    // atrybutu clazz (jedn z klasy Teacher i drug z
    // klasy Student) ale ma ju tylko jedn kopi name.
    std::cout << "Witam, nazywam si " << name << ". Wykadam '" << Teacher::clazz << "' ";
    std::cout << "i studiuj '" << Student::clazz << "'.\n";
}

    
int main() {


    // Utwrz obiekty.
    Teacher teacher("Kowalski", "Podstawy C++");
    Student student("Nowak", "Podstawy C++");
    TeachingStudent teachingStudent("Winiewski", "Podstawy C++", "Zaawansowane programowanie w C++");

    // Niech zajm si swoimi obowizkami.
    teacher.introduce();
    teacher.teach();
    student.introduce();
    student.attendClass();
    teachingStudent.introduce();
    teachingStudent.teach();
    teachingStudent.attendClass();
    
    std::cout << "Nacinij Enter lub Return, aby kontynuowa.\n";
    std::cin.get();
    return 0;
}
