// rational2.cpp - Listing 9.6

#include <iostream>

#include <string>

// Deklaracja klasy.
class Rational {
public:

    // Konstruktor.
    Rational(int num, int denom);

    // Przecione metody implementujce
    // funkcje arytmetyczne:
    Rational operator+(Rational rhs);
    Rational operator-(Rational rhs);
    Rational operator*(Rational rhs);
    Rational operator/(Rational rhs);

private:
    // Metoda normalize() zadba o przeksztacenie
    // licznika i mianownika do waciwej postaci.
    void normalize();

    int numerator;
    int denominator;

    // Funkcja operator<< bdzie odwoywaa si
    // do sklicznika i mianownika,
    // wic oznaczamy j jako zaprzyjanion.
    friend std::ostream& operator<<(std::ostream& os, Rational f);
    
};


// Definicja konstruktora.
Rational::Rational(int num, int denom) {
    numerator = num;
    denominator = denom;
    normalize();
}

// Przecienia operatorw.
Rational Rational::operator+(Rational rhs) {

    // a   c   a*d   c*b   a*d + c*b
    // - + - = --- + --- = ---------
    // b   d   b*d   b*d      b*d

    int a = numerator;
    int b = denominator;
    int c = rhs.numerator;
    int d = rhs.denominator;
    
    // Oblicz nowyliczniki i mianownik
    int e = a*d + c*b;
    int f = b*d;
    
    // Zwr wynikowy obiekt Rational
    return Rational(e, f);
}

Rational Rational::operator-(Rational rhs) {

    // a   c   a   -c
    // - - - = - + ---
    // b   d   b    d

    // Zmie znak prawego operandu
    rhs.numerator = -rhs.numerator;

    // I zwyczajnie dodaj za pomoc operatora +
    return operator+(rhs); 
}

Rational Rational::operator*(Rational rhs) {

    // a   c   a*c
    // - * - = ---
    // b   d   b*d

    int a = numerator;
    int b = denominator;
    int c = rhs.numerator;
    int d = rhs.denominator;
    
    // Oblicz nowyliczniki i mianownik
    int e = a*c;
    int f = b*d;
    
    // Zwr wynikowy obiekt Rational
    return Rational(e, f);
}

Rational Rational::operator/(Rational rhs) {

    // a   c   a   d
    // - / - = - * -
    // b   d   b   c

    // Odwr prawy operator
    int t = rhs.numerator;
    rhs.numerator = rhs.denominator;
    rhs.denominator = t;
    
    // I zwyczajnie pomn za pomoc operatora *
    return operator*(rhs); 
}


// Definicje metod.
void Rational::normalize() {

    // Sprawd znaki.
    if (denominator < 0) {
        // Przenie znak do mianownika.
        numerator = -numerator;
        denominator = -denominator;
    }

    // Oblicz najwikszy wsplny dzielnik a/b
    // algorytmem Euklidesa
    int a = abs(numerator);
    int b = abs(denominator);
    while (b > 0) {
        int t = a % b;
        a = b;
        b = t;
    }
    
    // Podziel obie liczby przez a.
    numerator /= a;
    denominator /= a;
}

// Prototyp funkcji operator<<()
std::ostream& operator<<(std::ostream& os, Rational f);


int main() {

    // Utwrz dwie liczby wymierne: 2/16 i 7/8.
    Rational f1(2, 16);
    Rational f2(7, 8);
    
    // Sprawdzian dodawania.
    std::cout << f1 << " + " << f2 << " == " << (f1+f2) << "\n";
    
    // Sprawdzian odejmowania.
    std::cout << f1 << " - " << f2 << " == " << (f1-f2) << "\n";
    
    // Sprawdzian mnoenia.
    std::cout << f1 << " * " << f2 << " == " << (f1*f2) << "\n";
    
    // Sprawdzian dzielenia.
    std::cout << f1 << " / " << f2 << " == " << (f1/f2) << "\n";
    
    std::cout << "Nacinij Enter lub Return, aby kontynuowa.\n";
    std::cin.get();
    return 0;
}  // Koniec funkcji main()

// Definicja operatora operator<<()
std::ostream& operator<<(std::ostream& os, Rational f) {

    // Wypisz do pobranego strumienia
    // licznik i mianownik uamka
    os << f.numerator << "/" << f.denominator;
    
    // Zwr obiekt strumienia, aby umoliwi zapisy kaskadowe
    return os;

}

