// temperature.cpp - Listing 5.2

// Potrzebujemy pliku iostream, by mc
// korzysta z cin i cout.
#include <iostream>

/* Prototyp pierwszej funkcji.
 * Funkcja nie pobiera argumentw.
 * Funkcja nie zwraca adnej wartoci.
 */
void promptAndWait();

/* Prototyp drugiej funkcji.
 * Funkcja pobiera dwa argumenty:
 * jeden typu float i jeden typu char.
 * Funkcja nie zwraca adnej wartoci.
 */
void convertTemperature(float tempIn, char typeIn);

// Pocztek funkcji main().
int main() {

    // Deklaracja zmiennych.
    float temperatureIn;
    char tempTypeIn;
    
    // Proba o podanie temperatury.
    std::cout << "Podaj temperatur i okrel, czy jest ona wyraona w stopniach Fahrenheita, czy Celsjusza: [##.# C/F] ";
    std::cin >> temperatureIn >> tempTypeIn;
    
    // Sprawdzenie poprawnoci wartoci zmiennej tempTypeIn.
    if  (
        (tempTypeIn == 'C') ||
        (tempTypeIn == 'c') ||
        (tempTypeIn == 'F') ||
        (tempTypeIn == 'f')
        ) {
           
           // Wywoanie funkcji konwertujcej.
           convertTemperature(temperatureIn, tempTypeIn);
           
    } else { // Niepoprawny typ danych, wypisanie komunikatu o bdzie.
        std::cout << "Obliczenia nie mogy zosta przeprowadzone ze wzgldu na niepoprawne dane wejciowe.\n\n";
    }
     
    //Wywoanie funkcji promptAndWait().
    promptAndWait();
             
    // Zwrcenie wartoci 0, by zaznaczy brak problemw.
    return 0;
             
} // Koniec funkcji main().


// Definicja funkcji promptAndWait().
void promptAndWait() {
    std::cin.ignore(100, '\n');
    std::cout << "Nacinij Enter lub Return, aby kontynuowa.\n";
    std::cin.get();
} // Koniec funkcji promptAndWait().


// Definicja funkcji convertTemperature().
void convertTemperature(float tempIn, char typeIn) {

    // Definicja staych 
    // uywanych w obliczeniach.
    const unsigned short ADD_SUBTRACT = 32;
    const float RATIO = 5.0/9.0;
         
    // Deklaracja zmiennych.
    float tempOut;
    char typeOut;
         
    // Wykonanie odpowiedniej konwersji w zalenoci od wartoci tempTypeIn.
    switch (typeIn) {
    
        case 'C':
        case 'c':
            // Obliczenia:
            tempOut = (tempIn / RATIO) + ADD_SUBTRACT;
            // Dla celw informacyjnych:
            typeOut = 'F';
            break;
            
        case 'F':
        case 'f':
            // Obliczenia:
            tempOut = (tempIn  - ADD_SUBTRACT) * RATIO;
            // Dla celw informacyjnych:
            typeOut = 'C';
            break;
            
    } // Koniec instrukcji switch.
    
    // Wypisanie wynikw.
    std::cout << tempIn << " stopni "
    << typeIn << " jest rwne " 
    << tempOut << " stopniom "
    << typeOut << ".\n\n";
        
} // Koniec funkcji convertTemperature().
