/**
 * This file is part of ComputerCraftEdu - http://www.computercraft.info
 * Copyright Daniel Ratcliffe and TeacherGaming LLC, 2013-2015. Do not distribute without permission.
 * Send enquiries to dratcliffe@gmail.com
 */

package dan200.computercraftedu.api;

import net.minecraft.block.Block;

import java.lang.reflect.Method;

public final class ComputerCraftEduAPI
{
    public static boolean isInstalled()
    {
        findCCEdu();
        return ccEdu != null;
    }

    public static String getInstalledVersion()
    {
        findCCEdu();
        if( ccEdu_getVersion != null )
        {
            try {
                return (String)ccEdu_getVersion.invoke( null );
            } catch (Exception e) {
                // It failed
            }
        }
        return "";
    }

    public static String getAPIVersion()
    {
        return "1.79";
    }

    public static boolean isTurtle( Block block )
    {
        findCCEdu();
        if( ccEdu_isTurtle != null )
        {
            try {
                return (Boolean)ccEdu_isTurtle.invoke( null, block );
            } catch (Exception e){
                // It failed
            }
        }
        return false;
    }

    public static void setTurtlesEnabled( boolean enabled )
    {
        findCCEdu();
        if( ccEdu_setTurtlesEnabled != null )
        {
            try {
                ccEdu_setTurtlesEnabled.invoke( null, enabled );
            } catch (Exception e){
                // It failed
            }
        }
    }

    public static void setTurtlesStopped( boolean stopped )
    {
        findCCEdu();
        if( ccEdu_setTurtlesStopped != null )
        {
            try {
                ccEdu_setTurtlesStopped.invoke( null, stopped );
            } catch (Exception e){
                // It failed
            }
        }
    }

    public static void setVisualEditorEnabled( boolean enabled )
    {
        findCCEdu();
        if( ccEdu_setVisualEditorEnabled != null )
        {
            try {
                ccEdu_setVisualEditorEnabled.invoke( null, enabled );
            } catch (Exception e){
                // It failed
            }
        }
    }

    public static void setSuggestionsEnabled( boolean enabled )
    {
        findCCEdu();
        if( ccEdu_setSuggestionsEnabled != null )
        {
            try {
                ccEdu_setSuggestionsEnabled.invoke( null, enabled );
            } catch (Exception e){
                // It failed
            }
        }
    }

    public static void setTurtlesCanBuild( boolean canBuild )
    {
        findCCEdu();
        if( ccEdu_setTurtlesCanBuild != null )
        {
            try {
                ccEdu_setTurtlesCanBuild.invoke( null, canBuild );
            } catch (Exception e){
                // It failed
            }
        }
    }

    private static void findCCEdu()
    {
        if( !ccEduSearched ) {
            try {
                ccEdu = Class.forName( "dan200.computercraftedu.ComputerCraftEdu" );
                ccEdu_getVersion = findCCEduMethod( "getVersion", new Class[]{
                } );
                ccEdu_isTurtle = findCCEduMethod( "isTurtle", new Class[]{
                    Block.class
                } );
                ccEdu_setTurtlesEnabled = findCCEduMethod( "setTurtlesEnabled", new Class[]{
                    Boolean.TYPE
                } );
                ccEdu_setTurtlesStopped = findCCEduMethod( "setTurtlesStopped", new Class[]{
                    Boolean.TYPE
                } );
                ccEdu_setVisualEditorEnabled = findCCEduMethod( "setVisualEditorEnabled", new Class[]{
                    Boolean.TYPE
                } );
                ccEdu_setSuggestionsEnabled = findCCEduMethod( "setSuggestionsEnabled", new Class[]{
                    Boolean.TYPE
                } );
                ccEdu_setTurtlesCanBuild = findCCEduMethod( "setTurtlesCanBuild", new Class[]{
                    Boolean.TYPE
                } );
           } catch( Exception e ) {
                System.out.println( "ComputerCraftEduAPI: ComputerCraftEdu not found." );
            } finally {
                ccEduSearched = true;
            }
        }
    }

    private static Method findCCEduMethod( String name, Class[] args )
    {
        try {
            if( ccEdu != null ) {
                return ccEdu.getMethod( name, args );
            }
            return null;
        } catch( NoSuchMethodException e ) {
            System.out.println( "ComputerCraftEduAPI: ComputerCraftEdu method " + name + " not found." );
            return null;
        }
    }

    private static boolean ccEduSearched = false;
    private static Class ccEdu = null;
    private static Method ccEdu_getVersion = null;
    private static Method ccEdu_isTurtle = null;
    private static Method ccEdu_setTurtlesEnabled = null;
    private static Method ccEdu_setTurtlesStopped = null;
    private static Method ccEdu_setVisualEditorEnabled = null;
    private static Method ccEdu_setSuggestionsEnabled = null;
    private static Method ccEdu_setTurtlesCanBuild = null;
}
