// Rysunek 26.9. Client.java
// Część kliencka bezpołączeniowej komunikacji typu klient – serwer wykorzystującej datagramy
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class Client extends JFrame 
{
   private JTextField enterField; // Umożliwa wpisanie komunikatu
   private JTextArea displayArea; // Wyświetlanie komunikatów
   private DatagramSocket socket; // Gniazdo do połączenia z serwerem

   // Konfiguracja interfejsu użytkownika i DatagramSocket
   public Client()
   {
      super("Klient");

      enterField = new JTextField("Tu wpisz wiadomość");
      enterField.addActionListener(
         new ActionListener() 
         { 
            public void actionPerformed(ActionEvent event)
            {
               try // Utwórz i wyślij pakiet
               {
                  // Pobierz wiadomość z pola tekstowego
                  String message = event.getActionCommand();
                  displayArea.append("\nWysyłanie pakietu zawierającego: " +
                     message + "\n");

                  byte[] data = message.getBytes(); // Konwersja na bajty
         
                  // Utworzenie sendPacket
                  DatagramPacket sendPacket = new DatagramPacket(data, 
                     data.length, InetAddress.getLocalHost(), 5000);

                  socket.send(sendPacket); // Wysłanie pakietu
                  displayArea.append("Pakiet wysłany\n");
                  displayArea.setCaretPosition(
                     displayArea.getText().length());
               } 
               catch (IOException ioException) 
               {
                  displayMessage(ioException + "\n");
                  ioException.printStackTrace();
               } 
            } 
         } 
      ); 

      add(enterField, BorderLayout.NORTH);

      displayArea = new JTextArea();
      add(new JScrollPane(displayArea), BorderLayout.CENTER);

      setSize(400, 300); // Ustaw rozmiar okna
      setVisible(true); // Wyświetl okno

      try // Utworzenie DatagramSocket w celu wysyłania i odbierania pakietów
      {
         socket = new DatagramSocket();
      } 
      catch (SocketException socketException) 
      {
         socketException.printStackTrace();
         System.exit(1);
      } 
   } 

   // Oczekiwanie na otrzymanie pakietów z serwera i wyświetlanie ich zawartości
   public void waitForPackets()
   {
      while (true) 
      {
         try // Pobierz pakiet i wyświetl zawartość
         {
            byte[] data = new byte[100]; // Konfiguracja pakietu
            DatagramPacket receivePacket = new DatagramPacket(
               data, data.length);

            socket.receive(receivePacket); // Oczekiwanie na pakiet

            // Wyświetlenie zawartości pakietu
            displayMessage("\nOtrzymano pakiet:" + 
               "\nZ hosta: " + receivePacket.getAddress() + 
               "\nPort hosta: " + receivePacket.getPort() + 
               "\nDługość: " + receivePacket.getLength() + 
               "\nZawartość:\n\t" + new String(receivePacket.getData(), 
                  0, receivePacket.getLength()));
         } 
         catch (IOException exception) 
         {
            displayMessage(exception + "\n");
            exception.printStackTrace();
         } 
      } 
   }

   // Modyfikacja displayArea w wątku obsługi zdarzeń
   private void displayMessage(final String messageToDisplay)
   {
      SwingUtilities.invokeLater(
         new Runnable()
         {
            public void run() // Aktualizacja displayArea
            {
               displayArea.append(messageToDisplay);
            }
         }  
      ); 
   } 
}  


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
