// Rysunek 23.10. Producer.java
// Klasa Producer z metodą run, która wstawia do bufora wartości od 1 do 10
import java.security.SecureRandom;

public class Producer implements Runnable {
   private static final SecureRandom generator = new SecureRandom();
   private final Buffer sharedLocation; // Referencja do współdzielonego obiektu

   // Konstruktor
   public Producer(Buffer sharedLocation) {
      this.sharedLocation = sharedLocation;
   } 

   // Zapamiętywanie wartości od 1 do 10 w sharedLocation
   @Override
   public void run() {                           
      int sum = 0;

      for (int count = 1; count <= 10; count++) {
         try { // Usypianie na od 0 do 3 sekund, a następnie umieszczenie wartości w Buffer
            Thread.sleep(generator.nextInt(3000)); // Zasypianie na losowy czas
            sharedLocation.blockingPut(count); // Ustawienie wartości w buforze
            sum += count; // Zwiększenie sumy wartości
            System.out.printf("\t%2d%n", sum);
         } 
         catch (InterruptedException exception) {
            Thread.currentThread().interrupt(); 
         } 
      } 

      System.out.printf(
         "Producer zakończył produkcję%nKończenie wątku Producer%n");
   } 
} 




/**************************************************************************
 * (C) Copyright 1992-2015 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/