// Rysunek 21.15. Tree.java
// Deklaracje klas TreeNode i Tree dla binarnego drzewa wyszukiwania
package com.deitel.datastructures;

// Definicja klasy TreeNode
class TreeNode<E extends Comparable<E>> {
   // Składowe o dostępie na poziomie pakietu
   TreeNode<E> leftNode;
   E data; // Wartość węzła
   TreeNode<E> rightNode;

   // Konstruktor inicjalizuje dane i czyni węzeł liściem
   public TreeNode(E nodeData) {
      data = nodeData;              
      leftNode = rightNode = null; // Węzeł nie ma potomków
   } 

   // Znajdź miejsce wstawiania i wstaw nowy węzeł; ignoruj duplikaty
   public void insert(E insertValue) {
      // Wstaw w lewym poddrzewie
      if (insertValue.compareTo(data) < 0) {
         // Wstaw nowy węzeł
         if (leftNode == null) {
            leftNode = new TreeNode<E>(insertValue);
         }
         else { // Kontynnuj przejście w lewym poddrzewie w sposób rekurencyjny
            leftNode.insert(insertValue); 
         }
      } 
      // Wstaw w prawym poddrzewie
      else if (insertValue.compareTo(data) > 0) {
         // Wstaw nowy węzeł
         if (rightNode == null) {
            rightNode = new TreeNode<E>(insertValue);
         }
         else { // Kontynnuj przejście w prawym poddrzewie w sposób rekurencyjny
            rightNode.insert(insertValue); 
         }
      } 
   } 
} 

// Definicja klasy Tree
public class Tree<E extends Comparable<E>> {
   private TreeNode<E> root;

   // Konstruktor inicjalizuje puste drzewo
   public Tree() {root = null;}

   // Wstaw nowy węzeł w binarnym drzewie wyszukiwania
   public void insertNode(E insertValue) {
      if (root == null) {
         root = new TreeNode<E>(insertValue); // Utwórsz korzeń
      }
      else {
         root.insert(insertValue); // Wywołaj metodę insert
      }
   } 

   // Rozpocznij przejście wzdłużne
   public void preorderTraversal() {preorderHelper(root);}

   // Metoda rekurencyjna wykonująca przejście wzdłużne
   private void preorderHelper(TreeNode<E> node) {
      if (node == null) {
         return;
      }

      System.out.printf("%s ", node.data); // Wyświetl wartość węzła
      preorderHelper(node.leftNode); // Przejdź do lewego poddrzewa
      preorderHelper(node.rightNode); // Przejdź do prawego poddrzewa 
   } 

   // Rozpocznij przejście poprzeczne
   public void inorderTraversal() {inorderHelper(root);}

   // Metoda rekurencyjna wykonująca przejście poprzeczne
   private void inorderHelper(TreeNode<E> node) {
      if (node == null) {
         return;
      }

      inorderHelper(node.leftNode); // Przejdź do lewego poddrzewa 
      System.out.printf("%s ", node.data); // Wyświetl wartość węzła
      inorderHelper(node.rightNode); // Przejdź do prawego poddrzewa
   } 

   // Rozpocznij przejście wsteczne
   public void postorderTraversal() {postorderHelper(root);}

   // Metoda rekurencyjna wykonująca przejście wsteczne
   private void postorderHelper(TreeNode<E> node) {
      if (node == null) {
         return;
      }
  
      postorderHelper(node.leftNode); // Przejdź do lewego poddrzewa   
      postorderHelper(node.rightNode); // Przejdź do prawego poddrzewa
      System.out.printf("%s ", node.data); // Wyświetl wartość węzła
   } 
}


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
