// Rysunek 19.5. InsertionSortTest.java
// Sortowanie przez wstawianie
import java.security.SecureRandom;
import java.util.Arrays;

public class InsertionSortTest {
   // Sortowanie tablicy algorytmem sortowania przez wstawianie
   public static void insertionSort(int[] data) {
      // Przejcie w ptli przez data.length - 1 elementw.              
      for (int next = 1; next < data.length; next++) {
         int insert = data[next]; // Warto do wstawienia   
         int moveItem = next; // Lokalizacja do wstawienia elementu

         // Poszukaj miejsca wstawienia aktualnego elementu
         while (moveItem > 0 && data[moveItem - 1] > insert) {
            // Przesu element w prawo o jedno miejsce                   
            data[moveItem] = data[moveItem - 1];              
            moveItem--;                                       
         }                                                    

         data[moveItem] = insert; // Umie wstawiany element
         printPass(data, next, moveItem); // Wywietl przebieg algorytmu
      }                                             
   }

   // Wywietl przebieg algorytmu
   public static void printPass(int[] data, int pass, int index) {
      System.out.printf("Po przebiegu %2d: ", pass);

      // Wywietlaj elementy a do wybranego
      for (int i = 0; i < index; i++) {
         System.out.printf("%d  ", data[i]);
      }                                             

      System.out.printf("%d* ", data[index]); // Wska zamian

      // Wywietl pozosta cz
      for (int i = index + 1; i < data.length; i++) {
         System.out.printf("%d  ", data[i]);
      }                                             

      System.out.printf("%n                 "); // Wyrwnanie

      // Wska posortowan cz tablicy
      for (int i = 0; i <= pass; i++) {
         System.out.print("--  ");
      }                                             
      System.out.println();
   } 

   public static void main(String[] args) {
      SecureRandom generator = new SecureRandom();

      // Utwrz nieposortowan tablic 10. liczb losowych
      int[] data = generator.ints(10, 10, 100).toArray(); 

      System.out.printf("Tablica nieposortowana: %s%n%n", Arrays.toString(data));
      insertionSort(data); // Posortuj tablic
      System.out.printf("%nTablica posortowana: %s%n", Arrays.toString(data));
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/