// Rysunek 7.14. GradeBook.java
// Klasa GradeBook służy do przechowywania tablicy z wynikami testu.

public class GradeBook {
   private String courseName; // Nazwa kusu reprezentowanego przez GradeBook.
   private int[] grades; // Tablica z ocenami.
   
   // Konstruktor.
   public GradeBook(String courseName, int[] grades) {
      this.courseName = courseName; 
      this.grades = grades; 
   } 

   // Metoda do ustawienia nazwy kursu.
   public void setCourseName(String courseName) {
      this.courseName = courseName; 
   } 

   // Metoda do pobrania nazwy kursu.
   public String getCourseName() {
      return courseName;
   } 

   // Wykonywanie różnych operacji na danych.
   public void processGrades() {
      // Wyświetlenie tablicy.
      outputGrades();

      // Wywołanie metody getAverage do obliczenia średniej ocen.
      System.out.printf("%nŚrednia ocen w klasie: %.2f%n", getAverage()); 

      // Wywołanie metod getMinimum i getMaximum.
      System.out.printf("Najniższa ocena: %d%nNajwyższa ocena: %d%n%n",
         getMinimum(), getMaximum());

      // Wywołanie outputBarChart w celu wyświetlenia wykresu słupkowego.
      outputBarChart();
   } 

   // Znajdź najniższą ocenę.
   public int getMinimum() {
      int lowGrade = grades[0]; // Załóż, że grades[0] jest najniższa.

      // Przejdź przez pętlę.                           
      for (int grade : grades) {                               
         // Jeśli grade jest mniejsza niż lowGrade, przypisz ją do lowGrade.
         if (grade < lowGrade) {                               
            lowGrade = grade; // Nowa najniższa ocena.             
         }                                                     
      }                                                        

      return lowGrade;
   } 

   // Znajdź najwyższą ocenę.
   public int getMaximum() {
      int highGrade = grades[0]; // Załóż, że grades[0] jest najwyższa.

      // Przejdź przez pętlę.                               
      for (int grade : grades) {                                  
         // Jeśli grade jest większa niż highGrade, przypisz ją do highGrade.
         if (grade > highGrade) {
            highGrade = grade; // Nowa najwyższa ocena.
         } 
      } 

      return highGrade; 
   } 

   // Określ średnią z testu.
   public double getAverage() {
      int total = 0;
 
      // Suma ocen.
      for (int grade : grades) {   
         total += grade;           
      }                            

      // Zwrócenie średniej ocen.
      return (double) total / grades.length;
   } 

   // Wyświetl wykres słupkowy z ocenami.
   public void outputBarChart() {
      System.out.println("Rozkład ocen:");

      // Przechowuje częstość wystąpień ocen w poszczególnych zakresach.
      int[] frequency = new int[11];
      
      // Dla każdej oceny zwiększ częstość odpowiedniego zakresu.
      for (int grade : grades) {                            
         ++frequency[grade / 10];                           
      }                                                     

      // Dla każdego zakresu narysuj wykres słupkowy.
      for (int count = 0; count < frequency.length; count++) {
         // Wyświetl etykietę ("00-09: ", ..., "90-99: ", "100: ").
         if (count == 10) {
            System.out.printf("%5d: ", 100); 
         } 
         else {
            System.out.printf("%02d-%02d: ", count * 10, count * 10 + 9);
         } 
         
         // Wyświetl słupek z gwiazdek.
         for (int stars = 0; stars < frequency[count]; stars++) {
            System.out.print("*");
         } 

         System.out.println(); 
      } 
   } 

   // Wyświetl zawartość tablicy.
   public void outputGrades() {
      System.out.printf("Oceny:%n%n");

      // Wyświetl ocenę poszczególnych uczniów.                             
      for (int student = 0; student < grades.length; student++) {
         System.out.printf("Uczeń %2d: %3d%n",                 
            student + 1, grades[student]);                       
      }                                                          
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
