// Rysunek 28.2. StreamMethods.java
// Nowe metody takeWhile, dropWhile, iterate i ofNullable
// dotyczące strumieni dostępne w Javie 9
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class StreamMethods {
   public static void main(String[] args) {
      int[] values = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

      System.out.printf("Tablica values zawiera: %s%n", 
         IntStream.of(values)
                  .mapToObj(String::valueOf)
                  .collect(Collectors.joining(" ")));

      // Pobierz największy przedrostek strumienia z elementami mniejszymi niż 6
      System.out.println("Przykład użycia takeWhile i dropWhile:");
      System.out.printf("Elementy mniejsze niż 6: %s%n", 
         IntStream.of(values)
                  .takeWhile(e -> e < 6)
                  .mapToObj(String::valueOf)
                  .collect(Collectors.joining(" ")));

      // Porzuć największy przedrostek strumienia z elementami mniejszymi niż 6
      System.out.printf("Elementy większe lub równe 6: %s%n", 
         IntStream.of(values)
                  .dropWhile(e -> e < 6)
                  .mapToObj(String::valueOf)
                  .collect(Collectors.joining(" ")));

      // Użyj iterate do wygenerowania strumienia potęg 3 mniejszych niż 10000
      System.out.printf("%nPrzykład użycia iterate:%n");
      System.out.printf("Potęgi 3 mniejsze niż 10 000: %s%n", 
         IntStream.iterate(3, n -> n < 10_000, n -> n * 3)
                  .mapToObj(String::valueOf)
                  .collect(Collectors.joining(" ")));

      // Przykład użycia ofNullable
      System.out.printf("%nPrzykład użycia ofNullable:%n");
      System.out.printf("Liczba elementów strumienia: %d%n", 
         Stream.ofNullable(null).count());
      System.out.printf("Liczba elementów strumienia: %d%n", 
         Stream.ofNullable("szary").count());
   }  
}


/*
 **************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 **************************************************************************
*/

