// Rysunek 26.3. Server.java
// Część serwerowa połączenia typu klient-serwer za pomocą gniazda strumieniowego
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class Server extends JFrame 
{
   private JTextField enterField; // Pobiera komunikat od użytkownika
   private JTextArea displayArea; // Wyświetla informacje użytkownikowi
   private ObjectOutputStream output; // Strumień wyjściowy do klienta
   private ObjectInputStream input; // Strumień wejściowy od klienta
   private ServerSocket server; // Gniazdo serwerowe
   private Socket connection; // Połączenie do klienta
   private int counter = 1; // Licznik połączeń

   // Konfiguracja interfejsu graficznego
   public Server()
   {
      super("Serwer");

      enterField = new JTextField(); // Utworzenie enterField
      enterField.setEditable(false);
      enterField.addActionListener(
         new ActionListener() 
         {
            // Wysłanie komunikatu do klienta
            public void actionPerformed(ActionEvent event)
            {
               sendData(event.getActionCommand());
               enterField.setText("");
            } 
         } 
      ); 

      add(enterField, BorderLayout.NORTH);

      displayArea = new JTextArea(); // Utworzenie displayArea
      add(new JScrollPane(displayArea), BorderLayout.CENTER);

      setSize(300, 150); // Ustaw rozmiar okna
      setVisible(true); // Wyświetl okno
   }

   // Skonfiguruj i uruchom serwer
   public void runServer()
   {
      try // Skonfiguruj serwer, aby odbierać połączenia; przetwarzanie połączeń
      {
         server = new ServerSocket(12345, 100); // Utworzenie ServerSocket

         while (true) 
         {
            try 
            {
               waitForConnection(); // Czekaj na połączenie
               getStreams(); // Pobierz strumienie: wejściowy i wyjściowy
               processConnection(); // Przetwórz połączenie
            } 
            catch (EOFException eofException) 
            {
               displayMessage("\nPołączenie zakończone przez serwer");
            } 
            finally 
            {
               closeConnection(); //  Zamknięcie połączenia
               ++counter;
            } 
         } 
      } 
      catch (IOException ioException) 
      {
         ioException.printStackTrace();
      } 
   }

   // Czekaj na otrzymanie połączenia, a następnie wyświetl informacje o połączeniu
   private void waitForConnection() throws IOException
   {
      displayMessage("Oczekiwanie na połączenie\n");
      connection = server.accept(); // Umożliw serwerowi odbieranie połączeń
      displayMessage("Połączenie numer " + counter + " odebrane od: " +
         connection.getInetAddress().getHostName());
   }

   // Pobierz strumienie dla odbierania i wysyłania danych
   private void getStreams() throws IOException
   {
      // Skonfiguruj strumień wyjściowy dla obiektów
      output = new ObjectOutputStream(connection.getOutputStream());
      output.flush(); // Opróżnij bufor, aby wymusić wysłanie informacji nagłówkowych

      // Skonfiguruj strumień wejściowy dla obiektów
      input = new ObjectInputStream(connection.getInputStream());

      displayMessage("\nOtrzymano strumienie wejściowy i wyjściowy\n");
   }

   // Przetwórz połączenie z klientem
   private void processConnection() throws IOException
   {
      String message = "Połączenie udane";
      sendData(message); // Wyślij komunikat o udanym połączeniu

      // Włącz enterField, aby serwer mógł wysyłać komunikaty
      setTextFieldEditable(true);

      do // Przetwarzaj komunikaty wysłane przez klient
      { 
         try // Odczytaj komunikat i go wyświetl
         {
            message = (String) input.readObject(); // Odczytaj nowy komunikat
            displayMessage("\n" + message); // Wyświetl komunikat
         } 
         catch (ClassNotFoundException classNotFoundException) 
         {
            displayMessage("\nOtrzymano nieznany typ obiektu");
         } 

      } while (!message.equals("KLIENT>>> PRZERWIJ"));
   }

   // Zamknij strumienie i gniazdo
   private void closeConnection() 
   {
      displayMessage("\nKończenie połączenia\n");
      setTextFieldEditable(false); // Wyłączenie enterField

      try 
      {
         output.close(); // Zamknij strumień wyjściowy
         input.close(); // Zamknij strumień wejściowy
         connection.close(); // Zamknij gniazdo
      } 
      catch (IOException ioException) 
      {
         ioException.printStackTrace();
      } 
   }

   // Wyślij wiadomość do klienta
   private void sendData(String message)
   {
      try // Wyślij obiekt do klienta
      {
         output.writeObject("SERWER>>> " + message);
         output.flush(); // Wymuś wysłanie do klienta
         displayMessage("\nSERWER>>> " + message);
      } 
      catch (IOException ioException) 
      {
         displayArea.append("\nBłąd zapisu obiektu");
      } 
   }

   // Modyfikuje displayArea w wątku obsługi zdarzeń
   private void displayMessage(final String messageToDisplay)
   {
      SwingUtilities.invokeLater(
         new Runnable() 
         {
            public void run() // Aktualizuje displayArea
            {
               displayArea.append(messageToDisplay); // Dodaje komunikat
            } 
         } 
      ); 
   } 

   // Modyfikuje enterField w wątku obsługi zdarzeń
   private void setTextFieldEditable(final boolean editable)
   {
      SwingUtilities.invokeLater(
         new Runnable()
         {
            public void run() // Ustawia możliwość edycji enterField
            {
               enterField.setEditable(editable);
            } 
         } 
      ); 
   } 
} 

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/