// Rysunek 23.11. Consumer.java
// Klasa Consumer z metodą run, która pobiera z bufora dziesięć wartości
import java.security.SecureRandom;

public class Consumer implements Runnable {
   private static final SecureRandom generator = new SecureRandom();
   private final Buffer sharedLocation; // Referencja do współdzielonego obiektu

   // Konstruktor
   public Consumer(Buffer sharedLocation) {
      this.sharedLocation = sharedLocation;
   }

   // Dziesięć odczytów wartości z sharedLocation i wyliczenie ich sumy
   @Override
   public void run() {                                       
      int sum = 0;

      for (int count = 1; count <= 10; count++) {
         // Usypianie na od 0 do 3 sekund, a następnie odczyt wartości z bufora i dodanie jej do sumy
         try {
            Thread.sleep(generator.nextInt(3000));
            sum += sharedLocation.blockingGet();          
            System.out.printf("\t\t\t%2d%n", sum);
         } 
         catch (InterruptedException exception) {
            Thread.currentThread().interrupt(); 
         } 
      } 

      System.out.printf("%n%s %d%n%s%n", 
         "Consumer odczytał wartości o sumie", sum, "Kończenie wątku Consumer");
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2015 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/