// Rysunek 23.4. TaskExecutor.java
// Użycie ExecutorService do wykonania zadań Runnable
import java.util.concurrent.Executors;
import java.util.concurrent.ExecutorService;

public class TaskExecutor {
   public static void main(String[] args) {
      // Utwórz i nazwij każde z zadań
      PrintTask task1 = new PrintTask("zadanie1");
      PrintTask task2 = new PrintTask("zadanie2");
      PrintTask task3 = new PrintTask("zadanie3");
        
      System.out.println("Uruchamianie wykonawcy zadań");

      // Utworzenie ExecutorService do zarządzania zadaniami
      ExecutorService executorService = Executors.newCachedThreadPool();

      // Wykonaj trzy zadania PrintTask
      executorService.execute(task1); // Uruchom zadanie1
      executorService.execute(task2); // Uruchom zadanie2
      executorService.execute(task3); // Uruchom zadanie3

      // Wyłącz ExecutorService -- on sam zdecyduje, kiedy wyłączyć wątki
      executorService.shutdown();

      System.out.printf("Zadania uruchomione, koniec main%n%n");
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2015 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/