// VideoPlayerController.java
// Użycie obiektów Media, MediaPlayer i MediaView do odtwarzania materiałów wideo
import java.net.URL;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.util.Duration;
import org.controlsfx.dialog.ExceptionDialog;

public class VideoPlayerController {  
   @FXML private MediaView mediaView;
   @FXML private Button playPauseButton;
   private MediaPlayer mediaPlayer;
   private boolean playing = false;
      
   public void initialize() {
      // Pobranie obiektu URL dla pliku wideo
      URL url = VideoPlayerController.class.getResource("sts117.mp4");
      
      // Utworzenie obiektu Media dla wskazanego obiektu URL
      Media media = new Media(url.toExternalForm());
      
      // Utworzenie obiektu MediaPlayer do sterowania odtwarzaniem Media
      mediaPlayer = new MediaPlayer(media);
      
      // Określenie, który MediaPlayer ma być wyświetlany w MediaView
      mediaView.setMediaPlayer(mediaPlayer); 

      // Ustawienie procedury obsługi wywoływanej po zakończeniu odtwarzania
      mediaPlayer.setOnEndOfMedia(
         new Runnable() {
            public void run() {
               playing = false;
               playPauseButton.setText("Odtwarzaj");
               mediaPlayer.seek(Duration.ZERO);
               mediaPlayer.pause();
            }
         }
      );
 
      // Ustawienie procedury obsługi wyświetlającej ExceptionDialog, jeśli dojdzie do błędu
      mediaPlayer.setOnError(
         new Runnable() {
            public void run() {
               ExceptionDialog dialog = 
                  new ExceptionDialog(mediaPlayer.getError());
               dialog.showAndWait();
            }
         }
      );
      
      // Ustawienie procedury obsługi zieniającej rozmiar okna na rozmiar wideo, gdy te jest gotowe do odtworzenia
      mediaPlayer.setOnReady(
         new Runnable() {
            public void run() {
               DoubleProperty width = mediaView.fitWidthProperty();
               DoubleProperty height = mediaView.fitHeightProperty();
               width.bind(Bindings.selectDouble(
                  mediaView.sceneProperty(), "width"));
               height.bind(Bindings.selectDouble(
                  mediaView.sceneProperty(), "height")); 
            }
         }
      );
   }  
   
   // Zmieniaj stan odtwarzania i treść przycisku playPauseButton
   @FXML
   private void playPauseButtonPressed(ActionEvent e) {
      playing = !playing;

      if (playing) {
         playPauseButton.setText("Pauza");
         mediaPlayer.play();
      }
      else {
         playPauseButton.setText("Odtwarzaj");
         mediaPlayer.pause();
      }
   } 
}

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
