// Rysunek 22.17: ThreeDimensionalShapesController.java
// Ustawienie materiałów używanych w kształtach 3D
import javafx.fxml.FXML;
import javafx.scene.paint.Color;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.image.Image;
import javafx.scene.shape.Box;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.Sphere;

public class ThreeDimensionalShapesController {
   // Zmienne instancji odnoszące się do kształtów 3D
   @FXML private Box box;       
   @FXML private Cylinder cylinder;       
   @FXML private Sphere sphere;       

   // Ustawianie materiałów dla wszystkich kształtów
   public void initialize() {
      // Definicja materiału dla obiektu Box.
      PhongMaterial boxMaterial = new PhongMaterial();
      boxMaterial.setDiffuseColor(Color.CYAN);      
      box.setMaterial(boxMaterial);

      // Definicja materiału dla obiektu Cylinder
      PhongMaterial cylinderMaterial = new PhongMaterial();
      cylinderMaterial.setDiffuseMap(new Image("yellowflowers.png"));      
      cylinder.setMaterial(cylinderMaterial);

      // Definicja materiału dla obiektu Sphere
      PhongMaterial sphereMaterial = new PhongMaterial();
      sphereMaterial.setDiffuseColor(Color.RED);      
      sphereMaterial.setSpecularColor(Color.WHITE);      
      sphereMaterial.setSpecularPower(32);      
      sphere.setMaterial(sphereMaterial);
   }
}

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
