// Rysunek 21.3. List.java
// Deklaracje klas ListNode i List
package com.deitel.datastructures;

import java.util.NoSuchElementException;

// Klasa reprezentująca jeden węzeł listy
class ListNode<E> {
   // Składowe o dostępie na poziomie pakietu. Klasa List ma do nich bezpośredni dostęp
   E data; // Dane tego węzła
   ListNode<E> nextNode; // Referencja do następnego węzła w liście

   // Konstruktor tworzy obiekt ListNode odnoszący się do object
   ListNode(E object) {this(object, null);}

   // Konstruktor tworzy obiekt ListNode, który odnosi się do object
   // i zawiera referencję do następnego ListNode
   ListNode(E object, ListNode<E> node) {
      data = object;    
      nextNode = node;  
   } 

   // Zwraca referencję na dane
   E getData() {return data;}

   // Zwraca referencję do następnego węzła na liście
   ListNode<E> getNext() {return nextNode;}
} 

// Definicja klasy List
public class List<E> {
   private ListNode<E> firstNode;
   private ListNode<E> lastNode; 
   private String name; // Tekst używany w trakcie wyświetlania listy

   // Konstruktor tworzy obiekt List z nazwą "lista"
   public List() {this("lista");}

   // Konstruktor tworzy obiekt List o zadanej nazwie
   public List(String listName) {
      name = listName;
      firstNode = lastNode = null;
   } 

   // Wstawia element na początku listy
   public void insertAtFront(E insertItem) {
      if (isEmpty()) { // firstNode i lastNode odnoszą się do tego samego obiektu
         firstNode = lastNode = new ListNode<E>(insertItem);
      } 
      else { // firstNode odnosi się do nowego węzła
         firstNode = new ListNode<E>(insertItem, firstNode);
      } 
   } 

   // Wstawia element na końcu listy
   public void insertAtBack(E insertItem) {
      if (isEmpty()) { // firstNode i lastNode odnoszą się do tego samego obiektu
         firstNode = lastNode = new ListNode<E>(insertItem);
      } 
      else { // nextNode z lastNode odnosi się do nowego węzła
         lastNode = lastNode.nextNode = new ListNode<E>(insertItem);
      } 
   } 

   // Usuń pierwszy węzeł listy
   public E removeFromFront() throws NoSuchElementException {
      if (isEmpty()) { // Zgłoś wyjątek, jeśli lista jest pusta
         throw new NoSuchElementException(name + " jest pusta");
      }

      E removedItem = firstNode.data; // Pobierz usuwane dane

      // Aktualizacja referencji firstNode i lastNode
      if (firstNode == lastNode) {
         firstNode = lastNode = null;
      }
      else {
         firstNode = firstNode.nextNode;
      }

      return removedItem; // Zwróć usunięte dane
   } 

   // Usuń ostatni węzeł listy.
   public E removeFromBack() throws NoSuchElementException {
      if (isEmpty()) { // Zgłoś wyjątek, jeśli lista jest pusta
         throw new NoSuchElementException(name + " jest pusta");
      }

      E removedItem = lastNode.data; // Pobierz usuwane dane

      // Aktualizacja referencji firstNode i lastNode
      if (firstNode == lastNode) {
         firstNode = lastNode = null;
      }
      else { // Znajdź nowy ostatni węzeł
         ListNode<E> current = firstNode;

         // Kontynuuj, gdy nextNode z current nie jest równe lastNode
         while (current.nextNode != lastNode) {
            current = current.nextNode;
         }
   
         lastNode = current; // current to nowe lastNode
         current.nextNode = null;
      } 

      return removedItem; // Zwróć usunięte dane
   } 

   // Określ, czy lista jest pusta; zwraca true, jeśli tak
   public boolean isEmpty() {return firstNode == null;}

   // Wyświetla zawartość listy
   public void print() {
      if (isEmpty()) {
         System.out.printf("Pusta %s%n", name);
         return;
      } 

      System.out.printf("%s zawiera: ", name);
      ListNode<E> current = firstNode;

      // Jeśli to nie koniec listy, wyświetl dane aktualnego węzła
      while (current != null) {
         System.out.printf("%s ", current.data);
         current = current.nextNode;
      } 

      System.out.println();
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
