// Rysunek 19.6. MergeSortTest.java
// Sortowanie przez scalanie
import java.security.SecureRandom;
import java.util.Arrays;

public class MergeSortTest {
   // Wywołaj rekurencyjną metodę sortArray, aby rozpocząć sortowanie
   public static void mergeSort(int[] data) {
      sortArray(data, 0, data.length - 1); // Sortuj całą tablicę
   }                                  

   // Dzieli tablicę, sortuje podtablice i scala posortowane podtablice
   private static void sortArray(int[] data, int low, int high) {
      // Sprawdź przypadek bazowy, czyli tablicę o rozmiarze 1
      if ((high - low) >= 1) { // Jeśli to nie przypadek bazowy
         int middle1 = (low + high) / 2; // Oblicz środek tablicy
         int middle2 = middle1 + 1; // Oblicz następny element po środku

         // Wyświetl krok podziału
         System.out.printf("Podział:   %s%n", 
            subarrayString(data, low, high));
         System.out.printf("           %s%n", 
            subarrayString(data, low, middle1));
         System.out.printf("           %s%n%n",
            subarrayString(data, middle2, high));

         // Podziel tablicę na pół; posortuj każdą połowę (wywołania rekurencyjne)
         sortArray(data, low, middle1); // Pierwsza połowa tablicy     
         sortArray(data, middle2, high); // Druga połowa tablicy   

         // Złączenie dwóch posortowanych przed powrotem
         merge (data, low, middle1, middle2, high);             
      }                                            
   }                               
   
   // Scalenie dwóch posortowanych podtablic w jedną posortowaną tablicę
   private static void merge(int[] data, int left, int middle1, 
      int middle2, int right) {

      int leftIndex = left; // Indeks dla lewej podtablicy         
      int rightIndex = middle2; // Indeks dla prawej podtablicy              
      int combinedIndex = left; // Indeks dla tablicy tymczasowej
      int[] combined = new int[data.length]; // Tablica robocza      
      
      // Wyświetl dwie podtablice przed scaleniem
      System.out.printf("Scalenie:  %s%n", 
         subarrayString(data, left, middle1));
      System.out.printf("           %s%n", 
         subarrayString(data, middle2, right));

      // Scalanie aż do osiągnięcia końca którejkolwiek z nich
      while (leftIndex <= middle1 && rightIndex <= right) {
         // Umieść mniejszy z dwóch aktualnych elementów jako wynik
         // i przejdź do następnego miejsca                   
         if (data[leftIndex] <= data[rightIndex]) {       
            combined[combinedIndex++] = data[leftIndex++]; 
         } 
         else {                                                 
            combined[combinedIndex++] = data[rightIndex++];
         } 
      } 
   
      // Jeśli lewa tablica jest pusta...                               
      if (leftIndex == middle2) {                             
         // skopiuj pozostałą część prawej tablicy                     
         while (rightIndex <= right) {                        
            combined[combinedIndex++] = data[rightIndex++];
         } 
      } 
      else { // Jeśli prawa tablica jest pusta...                             
         // skopiuj pozostałą część lewej tablicy                         
         while (leftIndex <= middle1) {                        
            combined[combinedIndex++] = data[leftIndex++]; 
         } 
      } 

      // Skopiuj wartości do pierwotnej tablicy
      for (int i = left; i <= right; i++) { 
         data[i] = combined[i];          
      } 

      // Wyświet scaloną tablicę
      System.out.printf("           %s%n%n", 
         subarrayString(data, left, right));
   } 

   // Metoda wyświetlająca pewne wartości z tablicy
   private static String subarrayString(int[] data, int low, int high) {
      StringBuilder temporary = new StringBuilder();

      // Użyj spacji do wyrównania
      for (int i = 0; i < low; i++) {
         temporary.append("   ");
      } 

      // Wyświetl elementy pozostałe w tablicy
      for (int i = low; i <= high; i++) {
         temporary.append(" " + data[i]);
      } 

      return temporary.toString();
   }

   public static void main(String[] args) {
      SecureRandom generator = new SecureRandom();

      // Utwórz nieposortowaną tablicę 10. liczb losowych
      int[] data = generator.ints(10, 10, 91).toArray(); 

      System.out.printf("Tablica nieposortowana: %s%n%n", Arrays.toString(data));
      mergeSort(data); // Sortowanie tablicy
      System.out.printf("Tablica posortowana: %s%n", Arrays.toString(data));
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/