// Rysunek 19.4. SelectionSortTest.java
// Sortowanie przez wybieranie
import java.security.SecureRandom;
import java.util.Arrays;

public class SelectionSortTest {
   // Sortowanie tablicy algorytmem sortowania przez wybieranie
   public static void selectionSort(int[] data) {
      // Przejcie w ptli przez data.length - 1 elementw      
      for (int i = 0; i < data.length - 1; i++) {
         int smallest = i; // Pierwszy indeks pozostaej czci tablicy

         // Znajd dziki ptli indeks najmniejszego elementu
         for (int index = i + 1; index < data.length; index++) {
            if (data[index] < data[smallest]) {
               smallest = index;                                        
             }                                                                 
         }                               
                                                                        
         swap(data, i, smallest); // Zamie najmniejszy element na pozycj
         printPass(data, i + 1, smallest); // Wywietl efekt przebiegu algorytmu 
      }                                                                 
   } 

   // Metoda pomocnicza zamienajca wartoci dwch elementw tablicy
   private static void swap(int[] data, int first, int second) {
      int temporary = data[first]; // Zapamitaj pierwszy element w zmiennej tymczasowej
      data[first] = data[second]; // Zastp pierwszy element drugim
      data[second] = temporary; // Umie zmienn tymczasow w drugim elemencie
   } 

   // Wywietl przebieg algorytmu
   private static void printPass(int[] data, int pass, int index) {
      System.out.printf("Po przebiegu %2d: ", pass);

      // Wywietlaj elementy a do wybranego
      for (int i = 0; i < index; i++) {
         System.out.printf("%d  ", data[i]);
      }

      System.out.printf("%d* ", data[index]); // Wska zamian

      // Wywietl pozosta cz
      for (int i = index + 1; i < data.length; i++) {
         System.out.printf("%d  ", data[i]);
      }

      System.out.printf("%n                 "); // Wyrwnanie

      // Wska posortowan cz tablicy
      for (int j = 0; j < pass; j++) {
         System.out.print("--  ");
      }
      System.out.println(); 
   }

   public static void main(String[] args) {
      SecureRandom generator = new SecureRandom();

      // Utwrz nieposortowan tablic 10. liczb losowych
      int[] data = generator.ints(10, 10, 100).toArray(); 

      System.out.printf("Tablica nieposortowana: %s%n%n", Arrays.toString(data));
      selectionSort(data); // Posortuj tablic
      System.out.printf("%nTablica posortowana: %s%n", Arrays.toString(data));
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/