// Rysunek 18.11. TowersOfHanoi.java
// Rozwiązanie problemu wieży Hanoi w sposób rekurencyjny
public class TowersOfHanoi {
   // Rekurencyjnie przenoś dyski między wieżami
   public static void solveTowers(int disks, int sourcePeg, 
      int destinationPeg, int tempPeg) {
      // Przypadek bazowy -- tylko jeden dysk do przeniesienia
      if (disks == 1) {
         System.out.printf("%n%d --> %d", sourcePeg, destinationPeg);
         return;
      } 

      // Krok rekurencyjny -- przeniesienie (disk - 1) dysków z sourcePeg
      // do tempPeg przy użyciu destinationPeg
      solveTowers(disks - 1, sourcePeg, tempPeg, destinationPeg);

      // Przeniesienie ostatniego dysku z sourcePeg do destinationPeg
      System.out.printf("%n%d --> %d", sourcePeg, destinationPeg);

      // Przeniesienie (disks - 1) dysków z tempPeg do destinationPeg
      solveTowers(disks - 1, tempPeg, destinationPeg, sourcePeg);
   }

   public static void main(String[] args) {
      int startPeg = 1; // Wartość 1 służy do oznaczenia kołka początkowego
      int endPeg = 3; // Wartość 3 służy do oznaczenia kołka końcowego
      int tempPeg = 2; // Wartość 2 służy do oznaczenia kołka tymczasowego
      int totalDisks = 3; // Liczba dysków.
      
      // Początkowe wywołanie nierekurencyjne -- przenosi wszystkie dyski
      solveTowers(totalDisks, startPeg, endPeg, tempPeg);
   }
}

/*************************************************************************
* (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
* Pearson Education, Inc. All Rights Reserved.                           *
*                                                                        *
* DISCLAIMER: The authors and publisher of this book have used their     *
* best efforts in preparing the book. These efforts include the          *
* development, research, and testing of the theories and programs        *
* to determine their effectiveness. The authors and publisher make       *
* no warranty of any kind, expressed or implied, with regard to these    *
* programs or to the documentation contained in these books. The authors *
* and publisher shall not be liable in any event for incidental or       *
* consequential damages in connection with, or arising out of, the       *
* furnishing, performance, or use of these programs.                     *
*************************************************************************/