// Rysunek 17.11. ArraysAndStreams.java
// Przykłady lambd i strumieni dla tablicy wartości Integer
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ArraysAndStreams {
   public static void main(String[] args) {
      Integer[] values = {2, 9, 5, 0, 3, 7, 1, 4, 8, 6};

      // Wyświetlenie oryginalnych wartości
      System.out.printf("Oryginalne wartości: %s%n", Arrays.asList(values));

      // Sortowanie wartości w porządku rosnącym za pomocą strumieni
      System.out.printf("Posortowane wartości: %s%n", 
         Arrays.stream(values)              
               .sorted()                    
               .collect(Collectors.toList()));

      // Wartości większe od 4
      List<Integer> greaterThan4 =           
         Arrays.stream(values)               
               .filter(value -> value > 4)   
               .collect(Collectors.toList());
      System.out.printf("Wartości większe od 4: %s%n", greaterThan4);

      // Przefiltruj wartości większe od 4 i posortuj wyniki
      System.out.printf("Posortowane wartości większe od 4: %s%n",
         Arrays.stream(values)              
               .filter(value -> value > 4)  
               .sorted()                    
               .collect(Collectors.toList()));

      // Lista greaterThan4 posortowana za pomocą strumienia
      System.out.printf(
         "Wartości większe od 4 (rosnąco w strumieniu): %s%n",
         greaterThan4.stream()              
               .sorted()                    
               .collect(Collectors.toList()));
   }
}


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
