// Rysunek 17.8. RandomIntegers.java
// Przesunięte i przeskalowane liczby losowe
import java.security.SecureRandom; 
import java.util.stream.Collectors;

public class RandomIntegers {
   public static void main(String[] args) {
      SecureRandom randomNumbers = new SecureRandom();          

      // Wyświetlenie 10 liczb losowych w osobnych wierszach
      System.out.println("Liczby losowe w osobnych wierszach:");
      randomNumbers.ints(10, 1, 7)
                   .forEach(System.out::println);

      // Wyświetlenie 10 liczb losowych w tym samym wierszu
      String numbers = 
         randomNumbers.ints(10, 1, 7)
                      .mapToObj(String::valueOf)
                      .collect(Collectors.joining(" "));
      System.out.printf("%nLiczby losowe w jednym wierszu: %s%n", numbers);

   } 
}



/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
