// Rysunek 16.10. DeckOfCards.java
// Przetasowanie talii kart jako przykład użycia metody shuffle klasy Collections
import java.util.List;
import java.util.Arrays;
import java.util.Collections;

// Klasa Card reprezentującą kartę z talii
class Card {
   public enum Face {As, Dwójka, Trójka, Czwórka, Piątka, Szóstka,
      Siódemka, Ósemka, Dziewiątka, Dziesiątka, Walet, Dama, Król }            
   public enum Suit {trefl, karo, kier, pik} 

   private final Face face; 
   private final Suit suit; 
   
   // Konstruktor
   public Card(Face face, Suit suit) {
       this.face = face; 
       this.suit = suit; 
   } 
   
   // Zwróć figurę karty
   public Face getFace() {return face;}

   // Zwróć kolor karty
   public Suit getSuit() {return suit;}

   // Zwróć tekstową reprezentację karty
   public String toString() {
      return String.format("%s %s", face, suit);
   } 
} 

// Deklaracja klasy DeckOfCards.
public class DeckOfCards {
   private List<Card> list; // Deklaracja List, która będzie przechowywać obiekty Card

   // Skonfiguruj talię kart i przemieszaj ją
   public DeckOfCards() {
      Card[] deck = new Card[52];
      int count = 0; // Numer karty

      // Wypełnij talię obiektami Card
      for (Card.Suit suit : Card.Suit.values()) {
         for (Card.Face face : Card.Face.values()) {  
            deck[count] = new Card(face, suit);
            ++count;
         } 
      } 

      list = Arrays.asList(deck); // Pobierz List  
      Collections.shuffle(list);  // Przemieszaj talię
   } 

   // Wyświetl karty
   public void printCards() {
      // Wyświetl wszystkie 52 karty w czterech kolumnach
      for (int i = 0; i < list.size(); i++) {
         System.out.printf("%-19s%s", list.get(i),
            ((i + 1) % 4 == 0) ? System.lineSeparator() : "");
      } 
   } 

   public static void main(String[] args) {
      DeckOfCards cards = new DeckOfCards();
      cards.printCards();
   }   
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
