// Rysunek 16.2. CollectionTest.java
// Interfejs Collection przedstawiony z wykorzystaniem obiektów ArrayList
import java.util.List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CollectionTest {
   public static void main(String[] args) {
      // Dodaj elementy tablicy z kolorami do listy
      String[] colors = {"MAGENTA", "CZERWONY", "BIAŁY", "NIEBIESKI", "CYJAN"};
      List<String> list = new ArrayList<String>();

      for (String color : colors) {
         list.add(color); // Dodaj kolor na końcu listy
      }

      // Dodaj elementy w tablicy removeColors do removeList
      String[] removeColors = {"CZERWONY", "BIAŁY", "NIEBIESKI"};
      List<String> removeList = new ArrayList<String>();

      for (String color : removeColors) {
         removeList.add(color);
      }

      // Wyświetl zawartość listy list
      System.out.println("ArrayList: ");

      for (int count = 0; count < list.size(); count++) {
         System.out.printf("%s ", list.get(count));
      }

      // Usuń z list kolory znajdujące się w removeList
      removeColors(list, removeList);

      // Wyświetl zawartość listy list
      System.out.printf("%n%nArrayList po wywołaniu removeColors:%n");

      for (String color : list) {
         System.out.printf("%s ", color);
      }
   } 

   // Usuwa kolory wskazane w collection2 z collection1
   private static void removeColors(Collection<String> collection1, 
      Collection<String> collection2) {
      // Pobierz iterator
      Iterator<String> iterator = collection1.iterator(); 

      // Przechodź przez elementy w pętli, dopóki są elementy
      while (iterator.hasNext()) {
         if (collection2.contains(iterator.next())) {   
            iterator.remove(); // Usuń aktualny element
         }                                              
      } 
   } 
}


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
