// Rysunek 15.3. CreateTextFile.java
// Zapis danych do sekwencyjnego pliku tekstowego dzięki klasie Formatter
import java.io.FileNotFoundException;     
import java.lang.SecurityException;       
import java.util.Formatter;               
import java.util.FormatterClosedException;
import java.util.NoSuchElementException;  
import java.util.Scanner;                 

public class CreateTextFile {
   public static void main(String[] args) {
      // Otwiera clients.txt, umieszcza w nim dane i zamyka plik clients.txt
      try (Formatter output = new Formatter("clients.txt")) {
		 Scanner input = new Scanner(System.in);
         System.out.printf("%s%n%s%n? ", 
            "Wpisz numer konta, imię, nazwisko i saldo.",
            "Wpisz wskaźnik końca danych, aby zakończyć.");
			
         while (input.hasNext()) { // Bądź w pętli aż do wskaźnika końca danych
            try {
               // Umieść rekord w pliku; załóż poprawność danych
               output.format("%d %s %s %.2f%n", input.nextInt(),  
                  input.next(), input.next(), input.nextDouble());
            } 
            catch (NoSuchElementException elementException) {
               System.err.println("Niepoprawne dane. Spróbuj ponownie.");
               input.nextLine(); // Pomiń dane, aby użytkownik mógł spróbować ponownie
            } 

            System.out.print("? ");
         }
      }
      catch (SecurityException | FileNotFoundException | 
         FormatterClosedException e) {
         e.printStackTrace();
      } 
   } 
}



/*************************************************************************
* (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
* Pearson Education, Inc. All Rights Reserved.                           *
*                                                                        *
* DISCLAIMER: The authors and publisher of this book have used their     *
* best efforts in preparing the book. These efforts include the          *
* development, research, and testing of the theories and programs        *
* to determine their effectiveness. The authors and publisher make       *
* no warranty of any kind, expressed or implied, with regard to these    *
* programs or to the documentation contained in these books. The authors *
* and publisher shall not be liable in any event for incidental or       *
* consequential damages in connection with, or arising out of, the       *
* furnishing, performance, or use of these programs.                     *
*************************************************************************/