// Rysunek 14.23: RegexSubstitution.java
// Metody replaceFirst, replaceAll i split klasy String
import java.util.Arrays;

public class RegexSubstitution {
   public static void main(String[] args) {
      String firstString = "To zdanie ma na końcu 5 gwiazdek *****";
      String secondString = "1, 2, 3, 4, 5, 6, 7, 8";
         
      System.out.printf("Oryginalny tekst 1: %s\n", firstString);

      // Zamień '*' na '^'
      firstString = firstString.replaceAll("\\*", "^");

      System.out.printf("^ zastąpiło *: %s\n", firstString);

      // Zamień 'gwiazdek' na 'karet'
      firstString = firstString.replaceAll("gwiazdek", "karet");

      System.out.printf(
         "\"karet\" zastąpiło \"gwiazdek\": %s\n", firstString);

      // Zamień każdy wyraz słowem 'wyraz'
      System.out.printf("Każdy wyraz zastąpiony słowem \"wyraz\": %s\n\n",
         firstString.replaceAll("\\w+", "wyraz"));

      System.out.printf("Oryginalny tekst 2: %s\n", secondString);

      // Zamień pierwsze trzy cyfry słowem 'cyfra'
      for (int i = 0; i < 3; i++) {
         secondString = secondString.replaceFirst("\\d", "cyfra");
      }

      System.out.printf(
         "Pierwsze cyfry zastąpione słowem \"cyfra\" : %s\n", secondString);

      System.out.print("Tekst po rozdzieleniu znakami przecinka: ");
      String[] results = secondString.split(",\\s*"); // Podział na podstawie przecinka
      System.out.println(Arrays.toString(results)); // Wyświetlenie wyniku
   } 
} 

/*
 **************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 **************************************************************************
*/


