// Rysunek 10.9. PayrollSystemTest.java
// Program testujący hierarchię klasy Employee.

public class PayrollSystemTest {
   public static void main(String[] args) {
      // Utwórz obiekty podklas.                                          
      SalariedEmployee salariedEmployee =                                 
         new SalariedEmployee("Jan", "Kowalski", "111-11-1111", 800.00);
      HourlyEmployee hourlyEmployee =                                     
         new HourlyEmployee("Anna", "Nowak", "222-22-2222", 16.75, 40);
      CommissionEmployee commissionEmployee =                             
         new CommissionEmployee(                                          
         "Zofia", "Lewandowska", "333-33-3333", 10000, .06);
      BasePlusCommissionEmployee basePlusCommissionEmployee =             
         new BasePlusCommissionEmployee(                                  
         "Robert", "Czekaj", "444-44-4444", 5000, .04, 300);

      System.out.println("Pracownicy przetwarzani pojedynczo:");

      System.out.printf("%n%s%n%s: %,.2f zł%n%n", 
         salariedEmployee, "zarobił", salariedEmployee.earnings());
      System.out.printf("%s%n%s: %,.2f zł%n%n",
         hourlyEmployee, "zarobił", hourlyEmployee.earnings());
      System.out.printf("%s%n%s: %,.2f zł%n%n",
         commissionEmployee, "zarobił", commissionEmployee.earnings());
      System.out.printf("%s%n%s: %,.2f zł%n%n", 
         basePlusCommissionEmployee, 
         "zarobił", basePlusCommissionEmployee.earnings());

      // Utwórz czteroelementową tablicę obiektów Employee.
      Employee[] employees = new Employee[4]; 

      // Zainicjalizuj tablicę obiektami Employees.
      employees[0] = salariedEmployee;          
      employees[1] = hourlyEmployee;            
      employees[2] = commissionEmployee;        
      employees[3] = basePlusCommissionEmployee;

      System.out.printf("Pracownicy przetwarzani polimorficznie:%n%n");

      // W uogólniony sposób przetwórz wszystkie obiekty tablicy employees.
      for (Employee currentEmployee : employees) {
         System.out.println(currentEmployee); // Wywołuje metodę toString.

         // Sprawdź, czy jest to BasePlusCommissionEmployee.
         if (currentEmployee instanceof BasePlusCommissionEmployee) {
            // Rzutuj referencję Employee
            // na referencję BasePlusCommissionEmployee.
            BasePlusCommissionEmployee employee = 
               (BasePlusCommissionEmployee) currentEmployee;

            employee.setBaseSalary(1.10 * employee.getBaseSalary());

            System.out.printf(
               "nowa stawka bazowa po 10%% podwyżki wynosi: %,.2f zł%n",
               employee.getBaseSalary());
         } 

         System.out.printf(
            "zarobił %,.2f zł%n%n", currentEmployee.earnings());
      } 

      // Pobierz nazwę typu każdego z obiektów w tablicy employees.
      for (int j = 0; j < employees.length; j++) {      
         System.out.printf("Pracownik %d to klasa %s%n", j,
            employees[j].getClass().getName());
      }                                                 
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
