// Rysunek 10.6. HourlyEmployee.java
// Klasa HourlyEmployee rozszerza klasę Employee.

public class HourlyEmployee extends Employee {
   private double wage; // Stawka godzinowa.
   private double hours; // Liczba godzin w tygodniu.

   // Konstruktor.
   public HourlyEmployee(String firstName, String lastName,
      String socialSecurityNumber, double wage, double hours) {
      super(firstName, lastName, socialSecurityNumber);

      if (wage < 0.0) { // Walidacja stawki.
         throw new IllegalArgumentException("Stawka godzinowa musi być >= 0.0");
      }

      if ((hours < 0.0) || (hours > 168.0)) { // Walidacja godzin.
         throw new IllegalArgumentException(
            "Przepracowane godziny muszą być >= 0.0 i <= 168.0");
      }

      this.wage = wage;
      this.hours = hours;
   } 

   // Ustaw stawkę.
   public void setWage(double wage) {
      if (wage < 0.0) { // Walidacja stawki.
         throw new IllegalArgumentException("Stawka godzinowa musi być >= 0.0");
      }

      this.wage = wage;
   } 

   // Zwróć stawkę.
   public double getWage() {return wage;}

   // Ustaw przepracowane godziny.
   public void setHours(double hours) {
      if ((hours < 0.0) || (hours > 168.0)) { // Walidacja godzin.
         throw new IllegalArgumentException(
            "Przepracowane godziny muszą być >= 0.0 i <= 168.0");
      }

      this.hours = hours;
   } 

   // Zwróć przepracowane godziny.
   public double getHours() {return hours;}

   // Zwróć zarobek; przesłoń abstrakcyjną metodę earnings z Employee.
   @Override                                                           
   public double earnings() {                                          
      if (getHours() <= 40) { // Brak nadgodzin.
         return getWage() * getHours();                                
      }                                                                
      else {                                                           
         return 40 * getWage() + (getHours() - 40) * getWage() * 1.5;  
      }                                                                
   }                                                                   

   // Zwróć tekstową reprezentację obiektu HourlyEmployee.
   @Override                                                             
   public String toString() {                                            
      return String.format("pracownik ze stawką godzinową: %s%n%s: %,.2f zł; %s: %,.2f",
         super.toString(), "stawka godzinowa", getWage(),
         "przepracowane godziny", getHours());
   }                                                                     
} 




/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
