// Rysunek 8.18. DrawRandomLinesController.java
// Rysowanie losowych linii za pomocą obiektów MyLine.
import java.security.SecureRandom;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.shape.ArcType;

public class DrawRandomLinesController { 
   private static final SecureRandom randomNumbers = new SecureRandom();
   @FXML private Canvas canvas;

   // Rysowanie losowych linii.
   @FXML
   void drawLinesButtonPressed(ActionEvent event) {
      // Pobranie GraphicsContext, który służy do rysowania na Canvas.
      GraphicsContext gc = canvas.getGraphicsContext2D();

      MyLine[] lines = new MyLine[100]; // Przechowuje obiekty MyLine.
      
      final int width = (int) canvas.getWidth();
      final int height = (int) canvas.getHeight();

      // Tworzy linie.
      for (int count = 0; count < lines.length; count++) {
         // Generuje losowe współrzędne.
         int x1 = randomNumbers.nextInt(width);
         int y1 = randomNumbers.nextInt(height);
         int x2 = randomNumbers.nextInt(width);
         int y2 = randomNumbers.nextInt(height);
         
         // Generuje losowy kolor.
         Color color = Color.rgb(randomNumbers.nextInt(256), 
            randomNumbers.nextInt(256), randomNumbers.nextInt(256));
         
         // Dodaje obiekt MyLine do tablicy.
         lines[count] = new MyLine(x1, y1, x2, y2, color);
      } 

      // Wyczyść Canvas, a następnie narysuj linie.
      gc.clearRect(0, 0, canvas.getWidth(), canvas.getHeight()); 

      for (MyLine line : lines) {
         line.draw(gc);
      } 
   }
}

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
