// Rysunek 7.22. ArrayManipulations.java
// Metody klasy Arrays i System.arraycopy.
import java.util.Arrays;

public class ArrayManipulations {
   public static void main(String[] args) {
      // Posortuj doubleArray w kolejności rosnącej.
      double[] doubleArray = {8.4, 9.3, 0.2, 7.9, 3.4};
      Arrays.sort(doubleArray); 
      System.out.printf("%ndoubleArray: ");

      for (double value : doubleArray) {
         System.out.printf("%.1f ", value);
      }

      // Wypełnij tablicę dziesięcioelementową siódemkami.
      int[] filledIntArray = new int[10]; 
      Arrays.fill(filledIntArray, 7);
      displayArray(filledIntArray, "filledIntArray");

      // Skopiuj tablicę intArray do tablicy intArrayCopy.
      int[] intArray = {1, 2, 3, 4, 5, 6};
      int[] intArrayCopy = new int[intArray.length];
      System.arraycopy(intArray, 0, intArrayCopy, 0, intArray.length);
      displayArray(intArray, "intArray");
      displayArray(intArrayCopy, "intArrayCopy");

      // Porównaj intArray i intArrayCopy pod kątem równości.
      boolean b = Arrays.equals(intArray, intArrayCopy);
      System.out.printf("%n%nintArray %s intArrayCopy%n", 
         (b ? "==" : "!="));

      // Porównaj intArray i filledIntArray pod kątem równości.
      b = Arrays.equals(intArray, filledIntArray);
      System.out.printf("intArray %s filledIntArray%n", 
         (b ? "==" : "!="));

      // Poszukaj w intArray wartości 5.
      int location = Arrays.binarySearch(intArray, 5);
      
      if (location >= 0) {
         System.out.printf(
            "Znaleziono 5 w elemencie %d z intArray%n", location); 
      } 
      else {
         System.out.println("Nie znaleziono 5 w intArray"); 
      } 

      // Poszukaj w intArray wartości 8763.
      location = Arrays.binarySearch(intArray, 8763);

      if (location >= 0) {
         System.out.printf(
            "Znaleziono 8763 w elemencie %d z intArray%n", location); 
      } 
      else {
         System.out.println("Nie znaleziono 8763 w intArray"); 
      } 
   } 

   // Wyświetl wartości tablicy.
   public static void displayArray(int[] array, String description) {
      System.out.printf("%n%s: ", description);

      for (int value : array) {
         System.out.printf("%d ", value);
      } 
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
