// Rysunek 7.18. GradeBook.java
// Klasa GradeBook używa tablicy dwuwymiarowej do przechowywania ocen. 

public class GradeBook {
   private String courseName; // Nazwa kursu, którego dotyczą oceny.
   private int[][] grades; // Dwuwymiarowa tablica ocen.
   
   // Konstruktor dwuargumentowy inicjalizuje nazwę kursu i tablicę dwuwymiarową.
   public GradeBook(String courseName, int[][] grades) {
      this.courseName = courseName; 
      this.grades = grades; 
   } 

   // Metoda do ustawienia nazwy kursu.
   public void setCourseName(String courseName) {
      this.courseName = courseName; 
   } 

   // Metoda do pobrania nazwy kursu.
   public String getCourseName() {
      return courseName;
   } 

   // Wykonuje różne operacje na danych.
   public void processGrades() {
      // Wyświetla tablicę.
      outputGrades();

      // Wywołuje metody getMinimum i getMaximum.
      System.out.printf("%n%s %d%n%s %d%n%n", 
         "Najniższa ocena w dzienniku to", getMinimum(), 
         "Najwyższa ocena w dzienniku to", getMaximum());

      // Wyświetl rozkład wszystkich ocen ze wszystkich testów.
      outputBarChart();
   } 

   // Znajdź najniższą ocenę.
   public int getMinimum() {
      // Załóż, że pierwsza ocena jest najniższa.     
      int lowGrade = grades[0][0];                           
                                                                 
      // Przejdź w pętli przez wiersza.
      for (int[] studentGrades : grades) {                       
         // Przejdź w pętli przez kolumny aktualnego wiersza.
         for (int grade : studentGrades) {                       
            // Jeśli grade jest mniejsza niż lowGrade, przypisz ją do lowGrade.
            if (grade < lowGrade) {                              
               lowGrade = grade;                                 
            }                                                    
         }                                                       
      }                                                          

      return lowGrade; 
   } 

   // Znajdź najwyższą ocenę.
   public int getMaximum() {
      // Załóż, że pierwsza ocena jest najwyższa.
      int highGrade = grades[0][0];

      // Przejdź w pętli przez wiersza.
      for (int[] studentGrades : grades) {
         // Przejdź w pętli przez kolumny aktualnego wiersza.
         for (int grade : studentGrades) {
            // Jeśli grade jest większa niż highGrade, przypisz ją do highGrade.
            if (grade > highGrade) {
               highGrade = grade;
            } 
         } 
      } 

      return highGrade; 
   } 

   // Określ średnią ocen.
   public double getAverage(int[] setOfGrades) {          
      int total = 0;                   
                                                          
      // Zsumuj oceny.                     
      for (int grade : setOfGrades) {                     
         total += grade;                                  
      }                                                   
                                                          
      // Zwróć średnią.                        
      return (double) total / setOfGrades.length;         
   }                              

   // Wykres słupkowy z łącznym rozkładem ocen.
   public void outputBarChart() {
      System.out.println("Łączny rozkład ocen:");

      // Przechowuje częstość wystąpień ocen w poszczególnych zakresach.
      int[] frequency = new int[11];
      
      // Dla każdej oceny zwiększ częstość odpowiedniego zakresu.
      for (int[] studentGrades : grades) {                               
         for (int grade : studentGrades) {                               
            ++frequency[grade / 10];                                     
         }                                                               
      }                                                                  

      // Dla każdego zakresu narysuj wykres słupkowy.
      for (int count = 0; count < frequency.length; count++) {
         // Wyświetl etykietę ("00-09: ", ..., "90-99: ", "100: ").
         if (count == 10) {
            System.out.printf("%5d: ", 100); 
         } 
         else {
            System.out.printf("%02d-%02d: ", 
               count * 10, count * 10 + 9); 
         } 
         
         // Wyświetl słupek z gwiazdek.
         for (int stars = 0; stars < frequency[count]; stars++) {
            System.out.print("*");
         } 

         System.out.println(); 
      } 
   } 

   // Wyświetl zawartość tablicy.
   public void outputGrades() {
      System.out.printf("Oceny:%n%n");
      System.out.print("          "); // Wyrównanie kolumn.

      // Utwórz początek kolumny dla każdego z testów.
      for (int test = 0; test < grades[0].length; test++) {
         System.out.printf("Test %d  ", test + 1);
      } 

      System.out.println("Średnia"); // Średnia dla ucznia.

      // Utwórz wiersze i kolumny reprezentujące oceny.
      for (int student = 0; student < grades.length; student++) {
         System.out.printf("Uczeń %2d", student + 1);

         for (int test : grades[student]) { // Wyświetl oceny.
            System.out.printf("%8d", test);                           
         } 

         // Wywołaj metodę getAverage, aby wyliczyć średnią dla ucznia.
         // Przekaż wiersz ocen jako argument do getAverage.
         double average = getAverage(grades[student]);
         System.out.printf("%9.2f%n", average);
      } 
   } 
} 



/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
