// Rysunek 7.10. DeckOfCards.java
// Klasa DeckOfCards reprezentuje talię kart do gry.
import java.security.SecureRandom;

public class DeckOfCards {
   // Generator liczb losowych.
   private static final SecureRandom randomNumbers = new SecureRandom();
   private static final int NUMBER_OF_CARDS = 52; // Stała liczba obiektów Card.

   private Card[] deck = new Card[NUMBER_OF_CARDS]; // Referencje do Card.
   private int currentCard = 0; // Indeks następnej karty do wydania (0-51).

   // Konstruktor wypełnia talię kart.
   public DeckOfCards() {
      String[] faces = {"As", "Dwójka", "Trójka", "Czwórka", "Piątka", "Szóstka",
         "Siódemka", "Ósemka", "Dziewiątka", "Dziesiątka", "Walet", "Dama", "Król"};    
      String[] suits = {"trefl", "karo", "kier", "pik"};       
	  
      // Wypełnij talię obiektami Card.                   
      for (int count = 0; count < deck.length; count++) {  
         deck[count] =                                     
            new Card(faces[count % 13], suits[count / 13]);
      }                                                    
   } 

   // Przetasuj talię kart algorytmem jednoprzebiegowym.
   public void shuffle() {
      // Następne wywołanie metody dealCard powinno zaczynać się ponownie od deck[0].
      currentCard = 0; 

      // Dla każdej Card wybierz inną, losową Card (0-51) i zamień je.
      for (int first = 0; first < deck.length; first++) {
         // Wybierz liczbę losową między 0 i 51.
         int second = randomNumbers.nextInt(NUMBER_OF_CARDS);

         // Zamień aktualne Card z losowo wybranym Card.
         Card temp = deck[first];   
         deck[first] = deck[second];
         deck[second] = temp;       
      } 
   } 

   // Wydaj jedną kartę z talii.
   public Card dealCard() {
      // Określ, czy są jeszcze karty do wydania.
      if (currentCard < deck.length) {
         return deck[currentCard++]; // Zwróć aktualną kartę z talii.
      } 
      else {
         return null; // Zwróć null, aby wskazać, że nie ma już więcej kart do rozdania.
      } 
   } 
} 



/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
