// Rysunek 6.8. Craps.java
// Klasa Craps symulująca grę w kości o nazwi craps
import java.security.SecureRandom;

public class Craps {
   // Utwórz bezpieczny generator liczb losowych używany w metodzie rollDice
   private static final SecureRandom randomNumbers = new SecureRandom();

   // Typ enum ze stałymi reprezentującymi stan gry
   private enum Status {CONTINUE, WON, LOST};                

   // Stałe reprezentujące typowe sumy rzutów kostkami
   private static final int SNAKE_EYES = 2;
   private static final int TREY = 3;      
   private static final int SEVEN = 7;     
   private static final int YO_LEVEN = 11; 
   private static final int BOX_CARS = 12; 

   // Jedna gra craps
   public static void main(String[] args) {
      int myPoint = 0; // Punkt, jeśli nie było wygranej lub przegranej w pierwszym rzucie
      Status gameStatus; // Może zawierać CONTINUE, WON lub LOST

      int sumOfDice = rollDice(); // Pierwszy rzut kostką

      // Określa stan gry i punkt na podstawie pierwszego rzutu
      switch (sumOfDice) {
         case SEVEN: // Wygrana w przypadku 7 w pierwszym rzucie  
         case YO_LEVEN: // Wygrana w przypadku 11 w pierwszym rzucie
            gameStatus = Status.WON;
            break;
         case SNAKE_EYES: // Przegrana w przypadku 2 w pierwszym rzucie  
         case TREY: // Przegrana w przypadku 3 w pierwszym rzucie
         case BOX_CARS: // Przegrana w przypadku 12 w pierwszym rzucie  
            gameStatus = Status.LOST;
            break;
         default: // Nie ma wygranej lub przegranej, zapamiętaj punkt
            gameStatus = Status.CONTINUE; // Gra jeszcze się nie zakończyła
            myPoint = sumOfDice; // Zapamiętaj punkt
            System.out.printf("Punkt to %d%n", myPoint);
            break; 
      }

      // Jeśli gra się jeszcze nie skończyła...
      while (gameStatus == Status.CONTINUE) { // Nie jest to WON lub LOST
         sumOfDice = rollDice(); // Ponownie rzuć kostkami

         // Określ stan gry.
         if (sumOfDice == myPoint) { // Wygrana, jeśli punkt
            gameStatus = Status.WON;
         } 
         else { 
            if (sumOfDice == SEVEN) { // Przegrana, jeśli rzucono 7
               gameStatus = Status.LOST;
            } 
         } 
      } 

      // Wyświetlenie komunikatu o wygranej lub przegranej
      if (gameStatus == Status.WON) {
         System.out.println("Gracz wygrał");
      } 
      else {
         System.out.println("Gracz przegrał");
      } 
   } 

   // Rzuć kostkami, oblicz sumę i wyświetl wynik
   public static int rollDice() {
      // Wybierz losowe wartości dla kostek
      int die1 = 1 + randomNumbers.nextInt(6); // Rzut pierwszą kostką
      int die2 = 1 + randomNumbers.nextInt(6); // Rzut drugą kostką

      int sum = die1 + die2; // Suma oczek z kostek

      // Wyświetl wyniki
      System.out.printf("Gracz wyrzucił %d + %d = %d%n", die1, die2, sum);

      return sum; 
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
