// Rysunek 4.4. Student.java
// Klasa Student przechowująca imię i nazwisko oraz średnią
public class Student {
   private String name; 
   private double average; 

   // Konstruktor inicjalizujący zmienne instancji
   public Student(String name, double average) {
      this.name = name;

      // Sprawdzenie, czy średnia jest > 0.0 i <= 100.0; w przeciwnym razie,
      // pozostaw domyślną wartość średniej, czyli (0.0)
      if (average > 0.0) {
         if (average <= 100.0) {
            this.average = average; // Przypisanie do zmiennej instancji
         }
      }
   }

   // Ustawia imię i nazwisko studenta
   public void setName(String name) {
      this.name = name; 
   }

   // Pobranie imienia i nazwiska studenta
   public String getName() {
      return name;
   }

   // Ustawienie średniej studenta
   public void setAverage(double average) {
      // Sprawdzenie, czy średnia jest > 0.0 i <= 100.0; w przeciwnym razie,
      // pozostaw aktualną wartość 
      if (average > 0.0) {
         if (average <= 100.0) {
            this.average = average; // Przypisanie do zmiennej instancji
         }
      }
   }

   // Pobranie średniej studenta
   public double getAverage() {
      return average;
   }

   // Określa i zwraca ocenę studenta w postaci literowej
   public String getLetterGrade() {
      String letterGrade = ""; // Początkowo użyj pustego obiektu String

      if (average >= 90.0) {
         letterGrade = "A";
      }
      else if (average >= 80.0) {
         letterGrade = "B";
      }
      else if (average >= 70.0) {
         letterGrade = "C";
      }
      else if (average >= 60.0) {
         letterGrade = "D";
      }
      else {
         letterGrade = "F";
      }

      return letterGrade;
   }
} 

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
