// Rysunek 26.5. Client.java
// Część kliencka połączenia między klientem i serwerem za pomocą gniazda strumieniowego
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class Client extends JFrame 
{
   private JTextField enterField; // Pobiera komunikat od użytkownika
   private JTextArea displayArea; // Wyświetla informacje użytkownikowi
   private ObjectOutputStream output; // Strumień wyjściowy do serwera
   private ObjectInputStream input; // Strumień wejściowy od serwera
   private String message = ""; // Komunikat z serwera
   private String chatServer; // Serwer dla aplikacji
   private Socket client; // Gniazdo do połączenia z serwerem

   // Inicjalizacja chatServer i konfiguracja interfejsu graficznego
   public Client(String host)
   {
      super("Klient");

      chatServer = host; // Ustaw serwer, z którym komunikuje się klient

      enterField = new JTextField(); // Utworzenie enterField
      enterField.setEditable(false);
      enterField.addActionListener(
         new ActionListener() 
         {
            // Wyślij komunikat do serwera
            public void actionPerformed(ActionEvent event)
            {
               sendData(event.getActionCommand());
               enterField.setText("");
            } 
         } 
      ); 

      add(enterField, BorderLayout.NORTH);

      displayArea = new JTextArea(); // Utworzenie displayArea
      add(new JScrollPane(displayArea), BorderLayout.CENTER);

      setSize(300, 150); // Ustaw rozmiar okna
      setVisible(true); // Pokaż okno
   }

   // Połącz z serwerem i przetwórz komunikaty od serwera
   public void runClient() 
   {
      try // Połącz z serwerem, pobierz strumienie i przetwórz połączenie
      {
         connectToServer(); // Utwórz Socket w celu utworzenia połączenia
         getStreams(); // Pobierz strumienie: wejściowy i wyjściowy
         processConnection(); // Przetwórz połączenie
      } 
      catch (EOFException eofException) 
      {
         displayMessage("\nPołączenie zakończone przez klienta");
      } 
      catch (IOException ioException) 
      {
         ioException.printStackTrace();
      } 
      finally 
      {
         closeConnection(); // Zamknij połączenie
      }
   }

   // Połącz z serwerem
   private void connectToServer() throws IOException
   {      
      displayMessage("Próba połączenia\n");

      // Utwórz obiekt Socket w celu połączenia z serwerem
      client = new Socket(InetAddress.getByName(chatServer), 12345);

      // Wyświetl informacje o połączeniu
      displayMessage("Połączono z: " + 
         client.getInetAddress().getHostName());
   }

   // Pobierz strumienie do pobierania i wysyłania danych
   private void getStreams() throws IOException
   {
      // Skonfiguruj strumień wyjściowy dla obiektów
      output = new ObjectOutputStream(client.getOutputStream());      
      output.flush(); // Opróżnij bufor, aby wymusić wysłanie informacji nagłówkowych

      // Skonfiguruj strumień wejściowy dla obiektów
      input = new ObjectInputStream(client.getInputStream());

      displayMessage("\nOtrzymano strumienie wejściowy i wyjściowy\n");
   }

   // Przetwórz połączenie z serwerem
   private void processConnection() throws IOException
   {
      // Włącz enterField, aby klient mógł wysyłać komunikaty
      setTextFieldEditable(true);

      do // Przetwórz komunikaty wysłane z serwera
      { 
         try // Odczytaj komunikat i go wyświetl
         {
            message = (String) input.readObject(); // Odczytaj nowy komunikat
            displayMessage("\n" + message); // Wyświetl komunikat
         } 
         catch (ClassNotFoundException classNotFoundException) 
         {
            displayMessage("\nOtrzymano nieznany typ obiektu");
         } 

      } while (!message.equals("SERWER>>> PRZERWIJ"));
   }

   // Zamknij strumienie i gniazdo
   private void closeConnection() 
   {
      displayMessage("\nKończenie połączenia\n");
      setTextFieldEditable(false); // Wyłączenie enterField

      try 
      {
         output.close(); // Zamknij strumień wyjściowy
         input.close(); // Zamknij strumień wejściowy
         client.close(); // Zamknij gniazdo
      } 
      catch (IOException ioException) 
      {
         ioException.printStackTrace();
      } 
   }

   // Wysłanie komunikatu na serwer
   private void sendData(String message)
   {
      try // Wysłanie obiektu na serwer
      {
         output.writeObject("KLIENT>>> " + message);
         output.flush(); // Wymuś wysłanie danych
         displayMessage("\nKLIENT>>> " + message);
      } 
      catch (IOException ioException)
      {
         displayArea.append("\nBłąd zapisu obiektu");
      } 
   }

   // Modyfikuje displayArea w wątku obsługi zdarzeń
   private void displayMessage(final String messageToDisplay)
   {
      SwingUtilities.invokeLater(
         new Runnable() 
         {
            public void run() // Aktualizuje displayArea
            {
               displayArea.append(messageToDisplay); // Dodaje komunikat
            } 
         } 
      ); 
   } 

   // Modyfikuje enterField w wątku obsługi zdarzeń
   private void setTextFieldEditable(final boolean editable)
   {
      SwingUtilities.invokeLater(
         new Runnable()
         {
            public void run() // Ustawia możliwość edycji enterField
            {
               enterField.setEditable(editable);
            } 
         } 
      ); 
   } 
} 

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
