// Rysunek 23.29. SortComparison.java
// Porównanie wydajności metod sort i parallelSort klasy Arrays
import java.time.Duration;
import java.time.Instant;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Random;

public class SortComparison {
   public static void main(String[] args) {
      Random random = new Random();

      // Utwórz tablicę losowych wartości, a następnie ją skopiuj 
      int[] array1 = random.ints(100_000_000).toArray();
      int[] array2 = array1.clone();

      // Czas sortowania array1 za pomocą metody sort z Arrays
      System.out.println("Rozpoczęcie sort");
      Instant sortStart = Instant.now();
      Arrays.sort(array1);              
      Instant sortEnd = Instant.now();  

      // Wyświetlenie czasu działania
      long sortTime = Duration.between(sortStart, sortEnd).toMillis();
      System.out.printf("Łączny czas w milisekundach: %d%n%n", sortTime);

      // Czas sortowania array2 za pomocą metody parallelSort z Arrays
      System.out.println("Rozpoczęcie parallelSort");
      Instant parallelSortStart = Instant.now();
      Arrays.parallelSort(array2);              
      Instant parallelSortEnd = Instant.now();  

      // Wyświetlenie czasu działania
      long parallelSortTime = 
         Duration.between(parallelSortStart, parallelSortEnd).toMillis();
      System.out.printf("Łączny czas w milisekundach: %d%n%n", 
         parallelSortTime);

      // Wyświetlenie różnicy czasów jako procentów
      String percentage = NumberFormat.getPercentInstance().format(
         (double) (sortTime - parallelSortTime) / parallelSortTime);                    
      System.out.printf("sort zajęło %s więcej czasu niż parallelSort%n", 
         percentage);
   }
}


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/