// Rysunek 23.18. CircularBuffer.java
// Synchronizacja dostępu do współdzielonego bufora trójelementowego
public class CircularBuffer implements Buffer {
   private final int[] buffer = {-1, -1, -1}; // Współdzielony bufor

   private int occupiedCells = 0; // Liczba aktualnie zajętych komórek bufora
   private int writeIndex = 0; // Indeks następnego elementu do zapisu
   private int readIndex = 0; // Indeks następnego elementu do odczytu
   
   // Umieszczenie wartości w buforze
   @Override
   public synchronized void blockingPut(int value)
      throws InterruptedException {               
   
      // Czekaj, aż bufor będzie miał dostępne miejsca, a następnie zapisz wartość
      // Jeśli nie ma wolnych miejsc, umiesć bufor w stanie oczekiwania
      while (occupiedCells == buffer.length) {                    
         System.out.printf("Buffer jest pełny. Producer czeka.%n");  
         wait(); // Czekaj, aż pojawi się wolna komórka            
      }                                            

      buffer[writeIndex] = value; // Ustaw nową wartość w buforze

      // Uaktualnij indeks zapisu cyklicznego
      writeIndex = (writeIndex + 1) % buffer.length;

      ++occupiedCells; // Zajętych jest o jeden więcej komórek
      displayState("Producer zapisuje " + value);
      notifyAll(); // Poinformuj wątki oczekujące o możliwości odczytu z bufora
   }
    
   // Zwróć wartość z bufora
   @Override
   public synchronized int blockingGet() throws InterruptedException {
      // Jeśli są dane w buforze, odczytaj je
      // Jeśli nie ma danych do odczytu, umiesć bufor w stanie oczekiwania
      while (occupiedCells == 0) { 
         System.out.printf("Buffer jest pusty. Consumer czeka.%n");
         wait(); // Czekaj, aż bufor wypełni się przynajmniej częściowo
      } 

      int readValue = buffer[readIndex]; // Odczytaj wartość z bufora

      // Uaktualnij indeks odczytu cyklicznego
      readIndex = (readIndex + 1) % buffer.length;

      --occupiedCells; // Zajętych jest o jeden mniej komórek
      displayState("Consumer odczytuje " + readValue);
      notifyAll(); // Poinformuj wątki oczekujące o możliwości zapisu do bufora

      return readValue;
   } 
    
   // Wyświetl aktualną operację i stan bufora
   public synchronized void displayState(String operation) {
      // Wyświetl operację i liczbę zajętych komórek
      System.out.printf("%s%s%d)%n%s", operation, 
         " (zajęte komórki: ", occupiedCells, "zawartość komórek:  ");

      for (int value : buffer) {
         System.out.printf(" %2d  ", value); // Wyświetl wartości z bufora
      }

      System.out.printf("%n                    ");

      for (int i = 0; i < buffer.length; i++) {
         System.out.print("---- ");
      }

      System.out.printf("%n                    ");

      for (int i = 0; i < buffer.length; i++) {
         if (i == writeIndex && i == readIndex) {
            System.out.print(" ZO"); // Zarówno zapis, jak i odczyt
         }
         else if (i == writeIndex) {
            System.out.print(" Z   "); // Tylko indeks zapisu
         }
         else if (i == readIndex) {
            System.out.print("  O  "); // Tylko indeks odczytu
         }
         else {
            System.out.print("     "); // Żaden z indeksów
         }
      } 

      System.out.printf("%n%n");
   } 
}


/**************************************************************************
 * (C) Copyright 1992-2015 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/