// Rysunek 23.3. PrintTask.java
// Klasa PrintTask wchodząca w stan uśpienia na losowy czas od 0 do 5 sekund
import java.security.SecureRandom;

public class PrintTask implements Runnable {
   private static final SecureRandom generator = new SecureRandom();
   private final int sleepTime; // Losowy czas uśpienia wątku
   private final String taskName; 
    
   // Konstruktor
   public PrintTask(String taskName) {
      this.taskName = taskName;
        
      // Wybierz losowo czas uśpienia od 0 do 5 sekund
      sleepTime = generator.nextInt(5000); // Milisekundy
   } 

   // Metoda run zawiera kod, który wykona wątek
   @Override
   public void run() {
      try { // Uśpij wątek na czas wskazany w sleepTime
         System.out.printf("%s idzie spać na %d milisekund%n", 
            taskName, sleepTime);
         Thread.sleep(sleepTime); // Uśpij wątek
      }       
      catch (InterruptedException exception) {
         exception.printStackTrace();
         Thread.currentThread().interrupt(); // Ponów przerwanie wątku
      } 
        
      // Wyświetl nazwę wątku
      System.out.printf("%s obudziło się%n", taskName); 
   } 
} 



/**************************************************************************
 * (C) Copyright 1992-2015 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/