// Rysunek 19.3. BinarySearchTest.java
// Użycie wyszukiwania binarnego do znalezienia elementu tablicy
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Scanner;

public class BinarySearchTest {
   // Wykonuje wyszukiwanie binarne na zbiorze danych
   public static int binarySearch(int[] data, int key) {
      int low = 0; // Dolna część obszaru wyszukiwania              
      int high = data.length - 1; // Górna część obszaru wyszukiwania
      int middle = (low + high + 1) / 2; // Element środkowy 
      int location = -1; // Zwracana wartość; -1, jeśli elementu nie znaleziono

      do { // Pętla poszukująca elementu
         // Wyświetl pozostałe elementy tablicy
         System.out.print(remainingElements(data, low, high));

         // Spacje odpowiadają za wyrównywanie
         for (int i = 0; i < middle; i++) {
            System.out.print("   ");
         }
         System.out.println(" * "); // Wskaż element środkowy

         // Jeśli element znajduje się na środku
         if (key == data[middle]) {                                  
            location = middle; // Położenie to aktualny środek  
         }                                                           
         else if (key < data[middle]) { // Środek jest za duży
            high = middle - 1; // Wyeliminuj drugą połowę        
         }                                                           
         else { // Środek jest za mały                 
            low = middle + 1; // Wyeliminuj pierwszą połowę      
         }                                                           

         middle = (low + high + 1) / 2; // Oblicz środek
      } while ((low <= high) && (location == -1));               

      return location; // Zwróć położenie klucza wyszukiwania
   }                         

   // Metoda wyświetlające pewne wartości z tablicy
   private static String remainingElements(
      int[] data, int low, int high) {
      StringBuilder temporary = new StringBuilder();

      // Dodaj spacje w celu wyrównania
      for (int i = 0; i < low; i++) {
         temporary.append("   ");
      }                         

      // Dodaj elementy pozostałe w tablicy
      for (int i = low; i <= high; i++) {
         temporary.append(data[i] + " ");
      }                         

      return String.format("%s%n", temporary);
   } 

   public static void main(String[] args) {
      Scanner input = new Scanner(System.in);
      SecureRandom generator = new SecureRandom();

      // Utwórz tablicę 15. losowych i posortowanych liczb całkowitych
      int[] data = generator.ints(15, 10, 100).sorted().toArray();
      System.out.printf("%s%n%n", Arrays.toString(data)); // Wyświetl tablicę

      // Pobranie danych od użytkownika
      System.out.print("Wpisz liczbę całkowitą (-1, aby zakończyć): ");
      int searchInt = input.nextInt(); 

      // Pobieranie w pętli liczby całkowitej; -1 przerywa program
      while (searchInt != -1) {
         // Wykonaj wyszukiwanie
         int location = binarySearch(data, searchInt);

         if (location == -1) { // Nie znaleziono
            System.out.printf("%d nie znaleziono%n%n", searchInt); 
         }                          
         else { // Znaleziono
            System.out.printf("%d znaleziono na pozycji %d%n%n", 
               searchInt, location);
         }                         
 
         // Pobranie danych od użytkownika
         System.out.print("Wpisz liczbę całkowitą (-1, aby zakończyć): ");
         searchInt = input.nextInt();
      } 
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/