// Rysunek 15.8. CreditInquiry.java
// Program odczytuje plik w sposób sekwencyjny i wyświetla
// zawartość na podstawie salda wybranego przez użytkownika
// (saldo dodatnie, saldo ujemne lub saldo zerowe)
import java.io.IOException;
import java.lang.IllegalStateException;
import java.nio.file.Paths;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class CreditInquiry {
   private final static MenuOption[] choices = MenuOption.values();

   public static void main(String[] args) {
      Scanner input = new Scanner(System.in);

      // Pobierz żądanie użytkownika (np. saldo dodatnie, saldo ujemne lub saldo zerowe)
      MenuOption accountType = getRequest(input);

      while (accountType != MenuOption.END) {
         switch (accountType) {
            case ZERO_BALANCE:
               System.out.printf("%nKonta z saldem zerowym:%n");
               break;
            case CREDIT_BALANCE:
               System.out.printf("%nKonta z saldem ujemnym:%n");
               break;
            case DEBIT_BALANCE:
               System.out.printf("%nKonta z saldem dodatnim:%n");
               break;
         } 

         readRecords(accountType);
         accountType = getRequest(input); // Pobierz żądanie użytkownika
      } 
   } 

   // Pobierz żądanie od użytkownika
   private static MenuOption getRequest(Scanner input) {
      int request = 4;

      // Wyświetl dostępne opcje.
      System.out.printf("%nWpisz żądanie%n%s%n%s%n%s%n%s%n",
         " 1 - Lista kont o saldzie zerowym",
         " 2 - Lista kont o saldzie ujemnym",
         " 3 - Lista kont o saldzie dodatnim",
         " 4 - Przerwij program");

      try {
         do { // Pobierz żądanie
            System.out.printf("%n? ");
            request = input.nextInt();
         } while ((request < 1) || (request > 4));
      } 
      catch (NoSuchElementException noSuchElementException) {
         System.err.println("Niepoprawne dane. Przerywam.");
      }

      return choices[request - 1]; // Zwróć wartość enum dla opcji
   }

   // Odczytaj rekordy z pliku i wyświetl tylko te, które mają odpowiedni typ
   private static void readRecords(MenuOption accountType) {
      // Otwórz plik i przetwórz zawartość
      try (Scanner input = new Scanner(Paths.get("clients.txt"))) {
         while (input.hasNext()) { // Więcej danych do odczytania
            int accountNumber = input.nextInt();
            String firstName = input.next();
            String lastName = input.next();
            double balance = input.nextDouble();

            // Jeśli odpowiednie saldo, wyświetl rekord
            if (shouldDisplay(accountType, balance)) {
               System.out.printf("%-10d%-12s%-12s%10.2f%n", accountNumber,
                  firstName, lastName, balance);
            }
            else {
               input.nextLine(); // Pomiń pozostałą część rekordu
            }
         }
      }
      catch (NoSuchElementException | IllegalStateException | 
         IOException e) {
         System.err.println("Błąd przetwarzania pliku. Przerywam.");
         System.exit(1);
      } 
   } 

   // Użyj salda do określenia, czy rekord należy wyświetlić
   private static boolean shouldDisplay(
      MenuOption option, double balance) {
      if ((option == MenuOption.CREDIT_BALANCE) && (balance < 0)) {
         return true;
      } 
      else if ((option == MenuOption.DEBIT_BALANCE) && (balance > 0)) {
         return true;
      } 
      else if ((option == MenuOption.ZERO_BALANCE) && (balance == 0)) {
         return true;
      } 

      return false;
   } 
}


/*************************************************************************
* (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
* Pearson Education, Inc. All Rights Reserved.                           *
*                                                                        *
* DISCLAIMER: The authors and publisher of this book have used their     *
* best efforts in preparing the book. These efforts include the          *
* development, research, and testing of the theories and programs        *
* to determine their effectiveness. The authors and publisher make       *
* no warranty of any kind, expressed or implied, with regard to these    *
* programs or to the documentation contained in these books. The authors *
* and publisher shall not be liable in any event for incidental or       *
* consequential damages in connection with, or arising out of, the       *
* furnishing, performance, or use of these programs.                     *
*************************************************************************/