// Rysunek 11.3. DivideByZeroWithExceptionHandling.java
// Obsługa wyjątków ArithmeticExceptions i InputMismatchExceptions
import java.util.InputMismatchException;
import java.util.Scanner;

public class DivideByZeroWithExceptionHandling
{
   // Przykład zgłoszenia wyjątku w momencie dzielenia przez 0
   public static int quotient(int numerator, int denominator)
      throws ArithmeticException {
      return numerator / denominator; // Możliwe dzielenie przez 0
   } 

   public static void main(String[] args) {
      Scanner scanner = new Scanner(System.in); 
      boolean continueLoop = true; // Określa, czy potrzebne są nadal dane wejściowe

      do {                                                                
         try { // Pobiera dwie liczby i wyświetla wynik             
            System.out.print("Wpisz licznik (liczba całkowita): ");    
            int numerator = scanner.nextInt();                            
            System.out.print("Wpisz mianownik (liczba całkowita): ");  
            int denominator = scanner.nextInt();                          
                                                                          
            int result = quotient(numerator, denominator);              
            System.out.printf("%nWynik: %d / %d = %d%n", numerator,     
               denominator, result);                                     
            continueLoop = false; // Udało się pobrać wartości i wyświetlić wynik; zakończ pętlę
         }                                                              
         catch (InputMismatchException inputMismatchException) {        
            System.err.printf("%nWyjątek: %s%n",                       
               inputMismatchException);                                  
            scanner.nextLine(); // Pomiń dane, aby użytkownik mógł spróbować ponownie
            System.out.printf(                                          
               "Musisz wpisać liczby całkowite. Spróbuj ponownie.%n%n");          
         }                                                              
         catch (ArithmeticException arithmeticException) {              
            System.err.printf("%nWyjątek: %s%n", arithmeticException);
            System.out.printf(                                          
               "Zero nie jest poprawnym mianownikiem. Spróbuj ponownie.%n%n");   
         }                                                              
      } while (continueLoop);                                           
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
