// Rysunek 10.5. SalariedEmployee.java
// Konkretna klasa SalariedEmployee rozszerza klasę abstrakcyjną Employee.

public class SalariedEmployee extends Employee {
   private double weeklySalary;

   // Konstruktor.
   public SalariedEmployee(String firstName, String lastName, 
      String socialSecurityNumber, double weeklySalary) {
      super(firstName, lastName, socialSecurityNumber); 

      if (weeklySalary < 0.0) {
         throw new IllegalArgumentException(
            "Tygodniowe wynagrodzenie musi być >= 0.0");
      }

      this.weeklySalary = weeklySalary;
   } 

   // Ustaw wynagrodzenie.
   public void setWeeklySalary(double weeklySalary) {
      if (weeklySalary < 0.0) {
         throw new IllegalArgumentException(
            "Tygodniowe wynagrodzenie musi być >= 0.0");
      }

      this.weeklySalary = weeklySalary;
   } 

   // Zwróć wynagrodzenie.
   public double getWeeklySalary() {return weeklySalary;}

   // Oblicz zarobek; przesłoń metodę abstrakcyjną earnings z Employee.
   @Override                                                           
   public double earnings() {return getWeeklySalary();}                

   // Zwróć tekstową reprezentację obiektu SalariedEmployee.
   @Override
   public String toString() {                                  
      return String.format("pracownik etatowy: %s%n%s: %,.2f zł",
         super.toString(), "wynagrodzenie tygodniowe", getWeeklySalary());
   }                                                           
} 



/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
